#pragma once

#include <common/folder.h>
#include <common/types.h>

namespace yimap {

class StatusCache
{
public:
    std::optional<FolderInfo> getFolder(const string& displayName)
    {
        lock_t lock(mutex);
        auto it = data.find(displayName);
        if (it != data.end() && it->second.validUntil >= Clock::now())
        {
            return it->second.folder;
        }
        return {};
    }

    void setFolder(const string& displayName, const FolderInfo& folder, uint32_t ttl)
    {
        // TODO Add displayName to FolderInfo. RTEC-4035
        Entry entry;
        entry.folder = folder;
        entry.validUntil = Clock::now() + Milliseconds(ttl);
        lock_t lock(mutex);
        data[displayName] = std::move(entry);
    }

private:
    struct Entry
    {
        FolderInfo folder;
        TimePoint validUntil;
    };

    std::map<string, Entry> data;
    mutex_t mutex;
};

typedef boost::shared_ptr<StatusCache> StatusCachePtr;

}
