#pragma once

#include <common/zerocopy.h>
#include <common/spirit_defs.h>
#include <boost/variant.hpp>

namespace yimap {

using TreeIterator = zerocopy::SegmentIt;

typedef boost::variant<int, unsigned, std::string, zerocopy::SegmentRange> TreeNodeData;
typedef BSP::node_iter_data_factory<TreeNodeData> TreeFactory;
typedef BSP::tree_match<TreeIterator, TreeFactory> TreeMatch;
typedef BSP::tree_parse_info<TreeIterator, TreeFactory> TreeInfo;
typedef TreeMatch::container_t Trees;
typedef TreeMatch::node_t TreeNode;

struct CommandAST
{
    CommandAST(TreeInfo&& _data) : data(_data)
    {
    }

    TreeInfo data;
};
typedef std::shared_ptr<CommandAST> CommandASTPtr;

}
