#pragma once

#include <string>
#include <memory>
#include <mutex>
#include <yplatform/ptree.h>
#include <yplatform/future/future.hpp>
#include <yplatform/task_context.h>
#include <yplatform/time_traits.h>
#include <yplatform/module.h> // XXX shared_from, weak_from

#include <boost/date_time/posix_time/posix_time.hpp>
#include <boost/shared_ptr.hpp>
#include <boost/system/error_code.hpp>
#include <boost/optional.hpp>
#include <cstddef>

#define capture_self self = shared_from(this)

namespace yimap {

namespace asio = boost::asio;
using std::string;
using std::wstring;
using std::size_t;
using namespace std::string_literals;

typedef std::shared_ptr<string> StringPtr;
typedef std::shared_ptr<const string> ConstStringPtr;

using IOService = boost::asio::io_service;
using ErrorCode = boost::system::error_code;

typedef std::function<void()> VoidFunction;
typedef std::function<void(const ErrorCode&)> ErrorCodeFunction;

typedef std::unique_lock<std::mutex> std_lock;

using Ptree = yplatform::ptree;

using Context = yplatform::task_context;
using ContextPtr = yplatform::task_context_ptr;

template <typename T>
using Future = yplatform::future::future<T>;

template <typename T>
using Promise = yplatform::future::promise<T>;

using Clock = yplatform::time_traits::clock;
using TimePoint = yplatform::time_traits::time_point;
using Duration = yplatform::time_traits::duration;
using Hours = yplatform::time_traits::hours;
using Minutes = yplatform::time_traits::minutes;
using Seconds = yplatform::time_traits::seconds;
using Milliseconds = yplatform::time_traits::milliseconds;
using FloatSeconds = yplatform::time_traits::float_seconds;
using Timer = yplatform::time_traits::timer;
using TimerPtr = yplatform::time_traits::timer_ptr;

using yplatform::shared_from;
using yplatform::weak_from;

namespace p = std::placeholders;

template <typename Dst, typename Src>
inline auto durationCast(Src&& src)
{
    return yplatform::time_traits::duration_cast<Dst>(std::forward<Src>(src));
}

inline auto toString(const Duration& d)
{
    return yplatform::time_traits::to_string(d);
}

template <typename T>
inline Future<T> makeFuture(T t)
{
    return yplatform::future::make_future(t);
}

inline Future<void> makeFuture()
{
    Promise<void> promise;
    promise.set();
    return promise;
}
}
