#pragma once

#include <common/types.h>
#include <common/sequence_ranges.h>
#include <boost/lexical_cast.hpp>

#include <set>

namespace yimap {

class UidSequence
{
public:
    void push(unsigned int uid)
    {
        uids_.insert(uid);
    }

    template <typename Seq>
    bool push(const Seq& uid_seq)
    {
        if (uid_seq.empty()) return true;
        try
        {
            typename Seq::const_iterator digit_beg = uid_seq.end();
            typename Seq::const_iterator i = uid_seq.begin();
            unsigned int range_start = 0;
            unsigned int range_end = 0;
            for (typename Seq::const_iterator i_end = uid_seq.end(); i != i_end; ++i)
            {
                if (std::isdigit(*i))
                {
                    if (digit_beg == i_end) digit_beg = i;
                }
                else if (*i == ':')
                {
                    range_start =
                        boost::lexical_cast<unsigned int>(boost::make_iterator_range(digit_beg, i));
                    digit_beg = i_end;
                }
                else if (*i == ',')
                {
                    if (range_start)
                        range_end = boost::lexical_cast<unsigned int>(
                            boost::make_iterator_range(digit_beg, i));
                    else
                        range_start = boost::lexical_cast<unsigned int>(
                            boost::make_iterator_range(digit_beg, i));

                    if (range_end)
                    {
                        unsigned temp_range = range_start;
                        range_start = std::min(temp_range, range_end);
                        range_end = std::max(temp_range, range_end);
                        while (range_start <= range_end)
                            uids_.insert(range_start++);
                    }
                    else
                    {
                        uids_.insert(range_start);
                    }

                    range_start = range_end = 0;
                    digit_beg = i_end;
                }
                else
                    return false;
            }
            if (range_start)
                range_end =
                    boost::lexical_cast<unsigned int>(boost::make_iterator_range(digit_beg, i));
            else
                range_start =
                    boost::lexical_cast<unsigned int>(boost::make_iterator_range(digit_beg, i));

            if (range_end)
            {
                unsigned temp_range = range_start;
                range_start = std::min(temp_range, range_end);
                range_end = std::max(temp_range, range_end);
                while (range_start <= range_end)
                    uids_.insert(range_start++);
            }
            else
            {
                uids_.insert(range_start);
            }
        }
        catch (...)
        {
            return false;
        }
        return true;
    }

    string to_string() const
    {
        if (uids_.empty()) return "";
        std::ostringstream result;
        std::set<unsigned int>::const_iterator i = uids_.begin();
        std::set<unsigned int>::const_iterator prev_i = uids_.begin();
        std::set<unsigned int>::const_iterator range_i = uids_.begin();
        unsigned int prev_uid = *i;
        ++i;
        for (std::set<unsigned int>::const_iterator i_end = uids_.end(); i != i_end; ++i)
        {
            if (*i - prev_uid == 1)
            {
                prev_uid = *i;
                prev_i = i;
                continue;
            }
            if (range_i != uids_.begin()) result << ",";
            if (range_i == prev_i) result << *range_i;
            else
                result << *range_i << ":" << *prev_i;

            range_i = i;
            prev_i = i;
            prev_uid = *i;
        }
        if (range_i != uids_.begin()) result << ",";
        if (range_i == prev_i) result << *range_i;
        else
            result << *range_i << ":" << *prev_i;
        return result.str();
    }

    bool empty() const
    {
        return uids_.empty();
    }

    std::size_t size() const
    {
        return uids_.size();
    }

private:
    std::set<unsigned int> uids_;
};

typedef boost::shared_ptr<UidSequence> UidSequencePtr;

} // namespace yimap
