#pragma once

#include <yplatform/zerocopy/streambuf.h>
#include <boost/range/iterator_range.hpp>

namespace yimap::zerocopy {

using Buffer = yplatform::zerocopy::streambuf;
using BufferPtr = boost::shared_ptr<Buffer>;
using BufferIt = Buffer::iterator;
using BufferRange = boost::iterator_range<BufferIt>;

using Segment = Buffer::segment_type;
using SegmentIt = Segment::iterator;
using SegmentRange = boost::iterator_range<SegmentIt>;

}
