#include "client_stream.h"
#include "session.h"
#include <common/imap_context.h>

#include <yplatform/net/buffers/chunk.h>

namespace yimap { namespace server {

ClientSreamImpl::~ClientSreamImpl()
{
    try
    {
        auto data = outstream.str();
        if (data.empty()) return;
        session->sendClientStream(yplatform::net::buffers::make_const_cstdcont_chunk(data));
    }
    catch (std::exception& e)
    {
        try
        {
            context->sessionLogger.logError()
                << "std::exception in ~ClientSreamImpl(): " << e.what();
        }
        catch (...)
        {
        }
    }
    catch (...)
    {
        try
        {
            context->sessionLogger.logError() << "unknown exception in ~ClientSreamImpl()";
        }
        catch (...)
        {
        }
    }
}

} // namespace server
} // namespace yimap
