#pragma once

#include <common/types.h>
#include <sstream>
#include <yplatform/net/streamable.h>

namespace yimap {

class ImapContext;
typedef boost::shared_ptr<ImapContext> ImapContextPtr;
typedef boost::weak_ptr<ImapContext> ImapContextWeakPtr;

namespace server {

class Session;
typedef boost::shared_ptr<Session> SessionPtr;

class ClientSreamImpl
{
public:
    explicit ClientSreamImpl(SessionPtr session, ImapContextPtr context)
        : session(session), context(context)
    {
    }
    ~ClientSreamImpl();

    template <typename T>
    ClientSreamImpl& operator<<(const T& t)
    {
        outstream << t;
        return *this;
    }

protected:
    SessionPtr session;
    ImapContextPtr context;
    std::ostringstream outstream;
};

class ClientStream
{
public:
    ClientStream(SessionPtr session, ImapContextPtr context)
        : impl(new ClientSreamImpl(session, context))
    {
    }
    ClientStream(ClientStream&& other) : impl(std::move(other.impl))
    {
    }
    ClientStream() = delete;
    ClientStream(const ClientStream&) = delete;
    ClientStream& operator=(const ClientStream&) = delete;

    template <typename T, class = typename std::enable_if<std::is_fundamental<T>::value>::type>
    ClientStream& operator<<(T t)
    {
        *impl << t;
        return *this;
    }

    ClientStream& operator<<(const std::string& str)
    {
        *impl << str;
        return *this;
    }

    template <typename iterator>
    ClientStream& operator<<(const boost::iterator_range<iterator>& t)
    {
        *impl << t;
        return *this;
    }

protected:
    std::unique_ptr<ClientSreamImpl> impl;
};

} // namespace server

typedef server::ClientStream ClientStream;

} // namespace yimap
