#ifndef _YIMAP_PARSER_ACCESS_VALUE_H_
#define _YIMAP_PARSER_ACCESS_VALUE_H_
#include <boost/spirit/include/classic_core.hpp>
#include <boost/spirit/include/classic_common.hpp>

namespace yimap { namespace parser {

namespace BSP = ::boost::spirit::classic;
namespace PH = ::phoenix;

struct AccessValueAction
{
    template <typename ParserT, typename ActionT>
    struct action;
};

template <typename ParserT, typename ActionT>
struct AccessValueAction::action
    : public BSP::unary<ParserT, BSP::parser<AccessValueAction::action<ParserT, ActionT>>>
{
    typedef BSP::action_parser_category parser_category;
    typedef action<ParserT, ActionT> self_t;

    action(ParserT const& subject, ActionT const& actor_);

    template <typename ScannerT>
    typename BSP::parser_result<self_t, ScannerT>::type parse(ScannerT const& scanner) const;

    ActionT const& predicate(void) const;

private:
    ActionT actor;
};

template <typename ParserT, typename ActionT>
AccessValueAction::action<ParserT, ActionT>::action(ParserT const& subject, ActionT const& actor_)
    : BSP::unary<ParserT, BSP::parser<AccessValueAction::action<ParserT, ActionT>>>(subject)
    , actor(actor_)
{
}

template <typename ParserT, typename ActionT>
template <typename ScannerT>
typename BSP::parser_result<AccessValueAction::action<ParserT, ActionT>, ScannerT>::type
AccessValueAction::action<ParserT, ActionT>::parse(ScannerT const& scan) const
{
    typedef typename BSP::parser_result<self_t, ScannerT>::type result_t;
    typedef typename ActionT::template result<void>::type action_result_t;

    if (!scan.at_end())
    {
        // iterator_t save = scan.first;
        result_t hit = (result_t)this->subject().parse(scan);
        action_result_t rc = actor(); //  (hit, save, scan.first);
        if (hit && hit.trees.size() > 0) hit.trees.begin()->value.value(rc);

        return hit;
    }
    return scan.no_match();
}

template <typename ParserT, typename ActionT>
ActionT const& AccessValueAction::action<ParserT, ActionT>::predicate(void) const
{
    return actor;
}

namespace {
const BSP::action_directive_parser_gen<AccessValueAction> access_value_d =
    BSP::action_directive_parser_gen<AccessValueAction>();
}

}}     // namespace yimap::parser
#endif // _YIMAP_PARSER_ACCESS_VALUE_H_
