#ifndef YIMAP_PARSER_COMMON_H
#define YIMAP_PARSER_COMMON_H

#include <common/spirit_defs.h>

//#include <boost/spirit.hpp>
#include <string>

#include <boost/range.hpp>

#include <iostream>
#include <iomanip>

namespace yimap { namespace parser {

using namespace BSP;
using namespace PH;

struct string_closure : BSP::closure<string_closure, std::string>
{
    member1 value;
};

template <typename Iter>
struct range_closure : BSP::closure<range_closure<Iter>, boost::iterator_range<Iter>>
{
    typedef typename BSP::closure<range_closure<Iter>, boost::iterator_range<Iter>> closure_;
    typename closure_::member1 value;
};

struct unsigned_closure : BSP::closure<unsigned_closure, unsigned int>
{
    member1 value;
};

struct date_ddmmyyyy
{
    short unsigned mday;
    short unsigned month;
    short unsigned year;
};

inline std::ostream& operator<<(std::ostream& os, const date_ddmmyyyy& v)
{
    os << v.mday << '/' << v.month << '/' << v.year;
    return os;
}

struct date_closure : BSP::closure<date_closure, date_ddmmyyyy>
{
    member1 dmy;
};

struct date_full
{
    unsigned short mday;
    unsigned short month;
    unsigned short year;

    unsigned short hour;
    unsigned short min;
    unsigned short sec;

    short zone;
};

inline std::ostream& operator<<(std::ostream& os, const date_full& v)
{
    using namespace std;
    os << setw(2) << setfill('0') << v.mday << '/' << setw(2) << setfill('0') << v.month << '/'
       << setw(4) << setfill('0') << v.year << ' ' << setw(2) << setfill('0') << v.hour << ':'
       << setw(2) << setfill('0') << v.min << ':' << setw(2) << setfill('0') << v.sec << ' '
       << (v.zone > 0 ? '+' : '-') << setw(4) << setfill('0') << abs(v.zone);
    return os;
}

struct date_time_closure : BSP::closure<date_time_closure, date_full>
{
    member1 d;
};

const chlit<> MINUS = ch_p('-');
const chlit<> DQUOTE = ch_p('"');
const chlit<> SP = ch_p(' ');
const chlit<> LPAR = ch_p('(');
const chlit<> RPAR = ch_p(')');
const chlit<> ESCAPE = ch_p('\\');
const strlit<> CRLF = str_p("\r\n");

}}

#endif // YIMAP_PARSER_COMMON_H
