#ifndef YIMAP_PARSER_DATE_GRAMMAR_H
#define YIMAP_PARSER_DATE_GRAMMAR_H

#include <common/spirit_defs.h>
#include <parser/common.h>

namespace yimap { namespace parser {

using namespace BSP;
using namespace PH;

struct date_month_parser
{
    struct no_chars
    {
    };

    typedef unsigned short result_t;

    template <typename ScannerT>
    typename ScannerT::value_t next(const ScannerT& scan) const
    {
        if (scan.at_end()) throw no_chars();
        typename ScannerT::value_t c = *scan;
        ++scan;
        return tolower(c);
    }

    template <typename ScannerT>
    std::ptrdiff_t operator()(const ScannerT& scan, result_t& result) const
    {
        try
        {
            switch (next(scan))
            {
            default:
                return -1;
            case 'j': // jan jun jul
                switch (next(scan))
                {
                default:
                    return -1;
                case 'a':
                    if (next(scan) != 'n') return -1;
                    result = 0;
                    break;

                case 'u':
                    switch (next(scan))
                    {
                    default:
                        return -1;
                    case 'n':
                        result = 5;
                        break;
                    case 'l':
                        result = 6;
                        break;
                    }
                    break;
                }
                break;
            case 'f': // feb
                if (next(scan) != 'e' || next(scan) != 'b') return -1;
                result = 1;
                break;
            case 'm': // mar may
                if (next(scan) != 'a') return -1;
                switch (next(scan))
                {
                default:
                    return -1;
                case 'r':
                    result = 2;
                    break;
                case 'y':
                    result = 4;
                    break;
                }
                break;
            case 'a': // apr aug
                switch (next(scan))
                {
                default:
                    return -1;
                case 'p':
                    if (next(scan) != 'r') return -1;
                    result = 3;
                    break;
                case 'u':
                    if (next(scan) != 'g') return -1;
                    result = 7;
                    break;
                }
                break;
            case 's': // sep
                if (next(scan) != 'e' || next(scan) != 'p') return -1;
                result = 8;
                break;
            case 'o': // oct
                if (next(scan) != 'c' || next(scan) != 't') return -1;
                result = 9;
                break;
            case 'n': // nov
                if (next(scan) != 'o' || next(scan) != 'v') return -1;
                result = 10;
                break;
            case 'd': // dec
                if (next(scan) != 'e' || next(scan) != 'c') return -1;
                result = 11;
                break;
            }
        }
        catch (const no_chars& e)
        {
            return -1;
        }

        return 3;
    }
};

extern const functor_parser<date_month_parser> date_month_p;

extern const uint_parser<unsigned short, 10, 1, 2> uint_1_2_p;
extern const uint_parser<unsigned short, 10, 4, 4> uint_4_4_p;
extern const uint_parser<unsigned short, 10, 1, 1> uint_1_1_p;
extern const uint_parser<unsigned short, 10, 2, 2> uint_2_2_p;

struct date_parser : public grammar<date_parser, date_closure::context_t>
{
    date_parser(bool fixed = false) : fixed_(fixed)
    {
    }

    const bool fixed_;

    template <typename ScannerT>
    struct definition
    {
        definition(const date_parser& self)
        {

            if (self.fixed_)
                top = ((discard_node_d[SP] >> uint_1_1_p /*[assign_a(self.dmy().mday)]*/) |
                       uint_2_2_p /*[assign_a(self.dmy().mday)]*/
                       ) >>
                    discard_node_d[ch_p('-')] >> date_month_p  /*[assign_a(self.dmy().month)]*/
                    >> discard_node_d[ch_p('-')] >> uint_4_4_p /*[assign_a(self.dmy().year)]*/
                    ;
            else
                top = uint_1_2_p                                 /*[assign_a(self.dmy().mday)]*/
                    >> discard_node_d[ch_p('-')] >> date_month_p /*[assign_a(self.dmy().month)]*/
                    >> discard_node_d[ch_p('-')] >> uint_4_4_p   /*[assign_a(self.dmy().year)]*/
                    ;

            BOOST_SPIRIT_DEBUG_NODE(top);
        }

        rule<ScannerT> top;
        const rule<ScannerT>& start() const
        {
            return top;
        }
    };
};

extern const date_parser date_text_p;
extern const date_parser date_text_fixed_p;

struct phoenix_sign
{
    template <typename T1, typename T2>
    struct result
    {
        typedef void type;
    };

    template <typename T1, typename T2>
    inline void operator()(T1& a, T2& b) const
    {
        a.zone = (b) ? -1 : 1;
    }
};

struct phoenix_set_date
{
    template <typename T1, typename T2>
    struct result
    {
        typedef void type;
    };

    template <typename T1, typename T2>
    inline void operator()(T1& a, T2& b) const
    {
        a.mday = b.mday;
        a.month = b.month;
        a.year = b.year;
    }
};

extern const phoenix::function<phoenix_sign> phoenix_sign_p;
extern const phoenix::function<phoenix_set_date> phoenix_set_date_p;

struct DateTimeParser : public grammar<DateTimeParser, date_time_closure::context_t>
{
    DateTimeParser()
    {
    }

    template <typename ScannerT>
    struct definition // : public grammar_def<rule<ScannerT>, same>
    {

        definition(const DateTimeParser& /*self*/)
        {
            date_time_rule = DQUOTE >> date_text_fixed_p //[phoenix_set_date_p(self.d, arg1)]
                >> SP >> limit_d(0u, 23u)[uint_2_2_p] /*[assign_a(self.d().hour)]*/ >> ':' >>
                limit_d(0u, 59u)[uint_2_2_p] /*[assign_a(self.d().min)]*/ >> ':' >>
                limit_d(0u, 59u)[uint_2_2_p] /*[assign_a(self.d().sec)]*/
                >> SP >> sign_p              //[phoenix_sign_p(self.d, arg1)]
                >> uint_4_4_p                //[var(self.d().zone) *= arg1]
                >> DQUOTE;

            BOOST_SPIRIT_DEBUG_NODE(date_time_rule);
        }

        typedef rule<ScannerT> rule_t;
        rule_t date_time_rule;
        rule_t const& start() const
        {
            return date_time_rule;
        }
    };
};

extern const DateTimeParser date_time_p;

}} // namespace yimap::parser

#endif // YIMAP_PARSER_DATE_GRAMMAR_H
