#ifndef _YIMAP_PARSER_GRAMMAR_H_
#define _YIMAP_PARSER_GRAMMAR_H_

#include <common/spirit_defs.h>
#include <common/tree.h>
#include <common/lex_ids.h>
#include <parser/common.h>

namespace yimap { namespace parser {

template <int N>
class MyParserTag : public BSP::parser_tag_base
{
public:
    inline MyParserTag(void) : tag(N)
    {
    }
    inline BSP::parser_id id(void) const
    {
        return tag;
    }
    inline void set_id(const BSP::parser_id& id)
    {
        tag = id;
    }

private:
    BSP::parser_id tag;
};

#define RULE(id) BSP::rule<ScannerT, MyParserTag<lex_ids::id>, BSP::parser_context<>>
#define RULE_CLOSURE(id, c) BSP::rule<ScannerT, MyParserTag<lex_ids::id>, c::context_t>

struct ImapGrammar : public BSP::grammar<ImapGrammar>
{
    template <typename ScannerT>
    struct definition
    {
        RULE(USERID) userid;
        RULE(PASSWORD) password;
        RULE(STRING) string;
        RULE(ASTRING) astring;

        RULE(MAILBOX) mailbox;
        RULE(DATE) date_p;

        RULE_CLOSURE(NUMBER, unsigned_closure) number;
        RULE_CLOSURE(NZ_NUMBER, unsigned_closure) nz_number;

        RULE(ADDRESS) address;
        RULE(ADDR_ADL) addr_adl;
        RULE(ADDR_HOST) addr_host;
        RULE(ADDR_MAILBOX) addr_mailbox;
        RULE(ADDR_NAME) addr_name;
        RULE(ASTRING_CHAR) ASTRING_CHAR;
        RULE(ATOM) atom;
        RULE(ATOM_CHAR) ATOM_CHAR;
        RULE(ATOM_SPECIALS) atom_specials;
        RULE(AUTH_TYPE) auth_type;
        RULE(BASE64) base64;
        RULE(BASE64_CHAR) base64_char;
        RULE(BASE64_TERMINAL) base64_terminal;
        RULE(BODY) body;
        RULE(BODY_EXTENSION) body_extension;
        RULE(BODY_EXT_1PART) body_ext_1part;
        RULE(BODY_EXT_MPART) body_ext_mpart;
        RULE(BODY_FIELDS) body_fields;
        RULE(BODY_FLD_DESC) body_fld_desc;
        RULE(BODY_FLD_DSP) body_fld_dsp;
        RULE(BODY_FLD_ENC) body_fld_enc;
        RULE(BODY_FLD_ID) body_fld_id;
        RULE(BODY_FLD_LANG) body_fld_lang;
        RULE(BODY_FLD_LOC) body_fld_loc;
        RULE(BODY_FLD_LINES) body_fld_lines;
        RULE(BODY_FLD_MD5) body_fld_md5;
        RULE(BODY_FLD_OCTETS) body_fld_octets;
        RULE(BODY_FLD_PARAM) body_fld_param;
        RULE(BODY_TYPE_1PART) body_type_1part;
        RULE(BODY_TYPE_BASIC) body_type_basic;
        RULE(BODY_TYPE_MPART) body_type_mpart;
        RULE(BODY_TYPE_MSG) body_type_msg;
        RULE(BODY_TYPE_TEXT) body_type_text;
        RULE(CAPABILITY) capability;
        RULE(CAPABILITY_DATA) capability_data;
        RULE(CHAR8) CHAR8;
        RULE(COMMAND_ANY) command_any;
        RULE(COMMAND_AUTH) command_auth;
        RULE(COMMAND_NONAUTH) command_nonauth;
        RULE(COMMAND_SELECT) command_select;
        RULE(CONTINUE_REQ) continue_req;
        RULE(DIGIT_NZ) digit_nz;
        RULE(ENVELOPE) envelope;
        RULE(ENV_BCC) env_bcc;
        RULE(ENV_CC) env_cc;
        RULE(ENV_DATE) env_date;
        RULE(ENV_FROM) env_from;
        RULE(ENV_IN_REPLY_TO) env_in_reply_to;
        RULE(ENV_MESSAGE_ID) env_message_id;
        RULE(ENV_REPLY_TO) env_reply_to;
        RULE(ENV_SENDER) env_sender;
        RULE(ENV_SUBJECT) env_subject;
        RULE(ENV_TO) env_to;
        RULE(FETCH_ATT) fetch_att;
        RULE(FETCH_ATTS) fetch_atts;
        RULE(FETCH_ATT) fetch_macro;
        RULE(FLAG) flag;
        RULE(FLAG_EXTENSION) flag_extension;
        RULE(FLAG_FETCH) flag_fetch;
        RULE(FLAG_KEYWORD) flag_keyword;
        RULE(FLAG_LIST) flag_list, store_att_flags_list;
        RULE(FLAG_PERM) flag_perm;
        RULE(GREETING) greeting;
        RULE(ID_PARAMS_LIST) id_params_list;
        RULE(HEADER_FLD_NAME) header_fld_name;
        RULE(HEADER_LIST) header_list;
        RULE(LIST) list;
        RULE(LIST_MAILBOX) list_mailbox;
        RULE(LIST_CHAR) list_char;
        RULE(LIST_WILDCARDS) list_wildcards;
        RULE(MAILBOX_DATA) mailbox_data;
        RULE(MAILBOX_LIST) mailbox_list;
        RULE(MBX_LIST_FLAGS) mbx_list_flags;
        RULE(MBX_LIST_OFLAG) mbx_list_oflag;
        RULE(MBX_LIST_SFLAG) mbx_list_sflag;
        RULE(MEDIA_BASIC) media_basic;
        RULE(MEDIA_MESSAGE) media_message;
        RULE(MEDIA_SUBTYPE) media_subtype;
        RULE(MEDIA_TEXT) media_text;
        RULE(MESSAGE_DATA) message_data;
        RULE(MSG_ATT) msg_att;
        RULE(MSG_ATT_DYNAMIC) msg_att_dynamic;
        RULE(MSG_ATT_STATIC) msg_att_static;
        RULE(NIL) nil;
        RULE(NSTRING) nstring;
        RULE(QUOTED) quoted;
        RULE(QUOTED_CHAR) QUOTED_CHAR;
        RULE(QUOTED_SPECIALS) quoted_specials;
        RULE(RESPONSE) response;
        RULE(RESPONSE_DATA) response_data;
        RULE(RESPONSE_DONE) response_done;
        RULE(RESPONSE_FATAL) response_fatal;
        RULE(RESPONSE_TAGGED) response_tagged;
        RULE(RESP_COND_AUTH) resp_cond_auth;
        RULE(RESP_COND_BYE) resp_cond_bye;
        RULE(RESP_COND_STATE) resp_cond_state;
        RULE(RESP_SPECIALS) resp_specials;
        RULE(RESP_TEXT) resp_text;
        RULE(RESP_TEXT_CODE) resp_text_code;
        RULE(SEARCH_KEY_AND) search_key, search_key_grp;
        RULE(SEARCH_KEY)
        search_key_bcc, search_key_body, search_key_cc, search_key_from, search_key_keyword,
            search_key_subject, search_key_text, search_key_to, search_key_unkeyword,
            search_key_larger, search_key_smaller, search_key_uid, search_key_group,
            search_key_header, search_key_or, search_key_list, search_key_not;

        RULE_CLOSURE(SEARCH_KEY, date_closure)
        search_key_since, search_key_on, search_key_before, search_key_sentsince, search_key_senton,
            search_key_sentbefore;

        RULE(SECTION) section, section_with_range;
        RULE(SECTION_MSGTEXT) section_msgtext;
        RULE(SECTION_PART) section_part;
        RULE(SECTION_SPEC) section_spec;
        RULE(SECTION_TEXT) section_text;
        RULE(SECTION_RANGE) section_range;
        RULE(SEQ_NUMBER) seq_number;
        RULE(SEQ_RANGE) seq_range;
        RULE(STATUS_ATT) status_att;
        RULE(STATUS_ATTS) status_atts;
        RULE(STATUS_ATT_LIST) status_att_list;
        RULE(STORE_ATT_SET_FLAGS) store_att_flags;
        RULE(TEXT) text;
        RULE(TEXT_CHAR) TEXT_CHAR;
        RULE(UNIQUEID) uniqueid;
        // RULE (X_COMMAND) x_command;

        RULE(SEQUENCE_SET) sequence_set;
        RULE(SEQUENCE_SET_TMP) sequence_set_tmp;

        RULE(TAG) tag;
        RULE(COMMAND) command;

        RULE(CMD_CAPABILITY) cmd_capability;
        RULE(CMD_LOGOUT) cmd_logout;
        RULE(CMD_NOOP) cmd_noop;
        RULE(CMD_ID) cmd_id;
        RULE(CMD_IDLE) cmd_idle;
        RULE(CMD_NAMESPACE) cmd_namespace;
        RULE(CMD_APPEND) cmd_append;
        RULE(CMD_CREATE) cmd_create;
        RULE(CMD_DELETE) cmd_delete;
        RULE(CMD_ENABLE) cmd_enable;
        RULE(CMD_EXAMINE) cmd_examine;
        RULE(CMD_LIST) cmd_list;
        RULE(CMD_X_LIST) cmd_x_list;
        RULE(CMD_LSUB) cmd_lsub;
        RULE(CMD_RENAME) cmd_rename;
        RULE(CMD_SELECT) cmd_select;
        RULE(CMD_STATUS) cmd_status;
        RULE(CMD_SUBSCRIBE) cmd_subscribe;
        RULE(CMD_UNSUBSCRIBE) cmd_unsubscribe;
        RULE(CMD_LOGIN) cmd_login;
        RULE(CMD_AUTHENTICATE) cmd_authenticate;
        RULE(CMD_STARTTLS) cmd_starttls;
        RULE(CMD_CHECK) cmd_check;
        RULE(CMD_CLOSE) cmd_close;
        RULE(CMD_UNSELECT) cmd_unselect;
        RULE(CMD_EXPUNGE) cmd_expunge;
        RULE(CMD_UID_EXPUNGE) cmd_uid_expunge;
        RULE(CMD_COPY) cmd_copy;
        RULE(CMD_MOVE) cmd_move;
        RULE(CMD_FETCH) cmd_fetch;
        RULE(CMD_STORE) cmd_store;
        RULE(CMD_UID) cmd_uid;
        RULE(CMD_SEARCH) cmd_search;

        RULE(NOTIFY_NONE) notify_none;
        RULE(NOTIFY_SET) notify_set;
        RULE(STATUS_INDICATOR) status_indicator;
        RULE(EVENT_GROUPS) event_groups;
        RULE(EVENT_GROUP) event_group;
        RULE(FILTER_MAILBOXES) filter_mailboxes;
        RULE(FILTER_MAILBOXES_OTHER) filter_mailboxes_other;
        RULE(FILTER_MAILBOXES_SELECTED) filter_mailboxes_selected;
        RULE(ONE_OR_MORE_MAILBOX) one_or_more_mailbox;
        RULE(MANY_MAILBOXES) many_mailboxes;
        RULE(EVENTS) events;
        RULE(EVENT) event;
        RULE(MESSAGE_EVENT) message_event;
        RULE(MAILBOX_EVENT) mailbox_event;
        RULE(USER_EVENT) user_event;
        RULE(EVENT_EXT) event_ext;

        BSP::rule<ScannerT> CTL;
        definition(const ImapGrammar& self);

        BSP::rule<ScannerT> top;

        BSP::rule<ScannerT> const& start(void) const
        {
            return top;
        }
    };
};

}} // namespace yimap::parser

#include <parser/grammar.inl>

#endif //
