#ifndef _YIMAP_PARSER_GRAMMAR_INL_
#define _YIMAP_PARSER_GRAMMAR_INL_

#include <common/spirit_defs.h>
#include <parser/grammar.h>
#include <parser/common.h>
#include <parser/date_grammar.h>
#include <parser/access_value.h>
#include <common/commands.h>
#include <parser/setid.h>

namespace yimap { namespace parser {
using namespace BSP;
using namespace PH;

struct literal_parser : public BSP::parser<literal_parser>
{
    inline literal_parser()
    {
    }

    typedef unsigned int literal_result_t;

    template <typename ScannerT>
    struct result
    {
        typedef typename BSP::match_result<ScannerT, literal_result_t>::type type;
    };

    template <typename ScannerT>
    typename BSP::parser_result<literal_parser, ScannerT>::type parse(ScannerT const& scan) const
    {
        typedef typename ScannerT::iterator_t iterator_t;

        literal_result_t result;

        typedef BSP::rule<ScannerT> rule_t;

        using namespace PH;

        static const BSP::uint_parser<unsigned, 10, 1, 32> number =
            BSP::uint_parser<unsigned, 10, 1, 32>();

        rule_t rule1 = !ch_p('~')                                       // binary literal
            >> ch_p('{') >> number[BSP::assign_a(result)] >> !ch_p('+') // literal plus
            >> ch_p('}') >> CRLF;

        std::ptrdiff_t len1 = rule1.parse(scan).length();
        if (len1 < 0) return scan.no_match();

        if (scan.last - scan.first >= (signed int)result)
        {
            iterator_t const s(scan.first);
            scan.first += result;
            return scan.create_match(std::size_t(len1 + result), result, s, scan.first);
        }
        else
            return scan.no_match();
    }
};

static const literal_parser literal_p;

#define IMAP_CMD(str, va) BSP::root_node_d[access_value_d[BSP::as_lower_d[str]][PH::val((int)va)]]

#define SET_ID(id, expr) BSP::access_node_d[expr][set_id(lex_ids::id)]

template <typename ScannerT>
ImapGrammar::definition<ScannerT>::definition(const ImapGrammar& /*self*/)
{
    using PH::arg1;
    using PH::arg2;
    using PH::construct_;
    using PH::new_;
    using PH::var;
    using PH::static_cast_;
    using PH::dynamic_cast_;
    using PH::const_cast_;
    using PH::reinterpret_cast_;

#define dCRLF BSP::discard_node_d[CRLF]
#define dSP BSP::discard_node_d[SP]

    //
    uint_parser<unsigned, 10, 1, 10> uint10_p;
    // uint_parser<unsigned, 10, 1, 20> uint20_p;
    // formal grammar

    CTL = BSP::range_p('\0', '\x1f') | BSP::ch_p('\x7f');

    // quoted_specials = DQUOTE | ESCAPE;
    // QUOTED_CHAR = (TEXT_CHAR - quoted_specials) | (ESCAPE >> quoted_specials);
    // quoted = DQUOTE >> (* QUOTED_CHAR) >> DQUOTE;

    address =
        LPAR >> addr_name >> dSP >> addr_adl >> dSP >> addr_mailbox >> dSP >> addr_host >> RPAR;

    // nil indicates group syntax; otherwise - domain name
    addr_adl = access_node_d[nstring][set_id(lex_ids::ADDR_ADL)];

    addr_host = access_node_d[nstring][set_id(lex_ids::ADDR_HOST)];
    addr_mailbox = access_node_d[nstring][set_id(lex_ids::ADDR_MAILBOX)];
    addr_name = access_node_d[nstring][set_id(lex_ids::ADDR_NAME)];

    cmd_append = IMAP_CMD("append", CMD_APPEND) >> dSP >> mailbox >>
        !(dSP >> gen_pt_node_d[flag_list]) >>
        !(dSP >> access_node_d[date_time_p][set_id(lex_ids::DATE_TIME)]) >> dSP >>
        access_node_d[literal_p][set_id(lex_ids::RFC822_MESSAGE)];

    astring = BSP::token_node_d[+ASTRING_CHAR] | string;

    ASTRING_CHAR = ATOM_CHAR | resp_specials;
    atom = +ATOM_CHAR;

    ATOM_CHAR = anychar_p - atom_specials;
    atom_specials = chset_p("(){") | dSP | CTL | list_wildcards | quoted_specials | resp_specials;

    // XXX
    cmd_authenticate = IMAP_CMD("authenticate", CMD_AUTHENTICATE) >> +(dSP >> atom);

    auth_type = atom; // Defined by SASL

    base64 = *(repeat_p(4)[base64_char]) >> !(base64_terminal);

    base64_char = alnum_p | ch_p('+') | ch_p('/');
    base64_terminal = (base64_char >> base64_char >> str_p("==")) |
        (base64_char >> base64_char >> base64_char >> ch_p('='));

    body = LPAR >> (body_type_1part | body_type_mpart) >> RPAR;
    body_extension = nstring | number | (LPAR >> *(dSP >> body_extension) >> RPAR);

    body_ext_1part = body_fld_md5 >>
        !(dSP >> body_fld_dsp >>
          !(dSP >> body_fld_lang >> !(dSP >> body_fld_loc >> *(dSP >> body_extension))));

    body_ext_mpart = body_fld_param >>
        !(dSP >> body_fld_dsp >>
          !(dSP >> body_fld_lang >> !(dSP >> body_fld_loc >> *(dSP >> body_extension))));

    body_fields = body_fld_param >> dSP >> body_fld_id >> dSP >> body_fld_desc >> dSP >>
        body_fld_enc >> dSP >> body_fld_octets;

    body_fld_desc = BSP::access_node_d[nstring][set_id(lex_ids::BODY_FLD_DESC)];
    body_fld_dsp = (LPAR >> string >> dSP >> body_fld_param >> RPAR) | nil;
    body_fld_enc = (DQUOTE >> (as_lower_d["7bit"] | as_lower_d["8bit"] | as_lower_d["binary"] |
                               as_lower_d["base64"] | as_lower_d["quoted_printable"]) >>
                    DQUOTE) |
        string;
    body_fld_id = nstring;
    body_fld_lang = nstring | (LPAR >> string >> *(dSP >> string) >> RPAR);
    body_fld_loc = nstring;
    body_fld_lines = number;
    body_fld_md5 = nstring;
    body_fld_octets = number;
    body_fld_param =
        (LPAR >> string >> dSP >> string >> *(dSP >> string >> dSP >> string) >> RPAR) | nil;
    body_type_1part =
        (body_type_basic | body_type_msg | body_type_text) >> !(dSP >> body_ext_1part);
    body_type_basic = media_basic >> dSP >> body_fields;

    body_type_mpart = +body >> dSP >> media_subtype >> !(dSP >> body_ext_mpart);

    body_type_msg = media_message >> dSP >> body_fields >> dSP >> envelope >> dSP >> body >> dSP >>
        body_fld_lines;

    body_type_text = media_text >> dSP >> body_fields >> dSP >> body_fld_lines;

    cmd_capability = IMAP_CMD("capability", CMD_CAPABILITY);

    capability = (as_lower_d["auth="] >> auth_type) | atom;
    capability_data = as_lower_d["capability"] >> *(dSP >> capability) >> dSP >> "IMAP4rev1" >>
        *(dSP >> capability);

    // any octet except nil (%x00)
    CHAR8 = anychar_p - ch_p('\0');

    cmd_check = IMAP_CMD("check", CMD_CHECK);

    cmd_close = IMAP_CMD("close", CMD_CLOSE);

    cmd_unselect = IMAP_CMD("unselect", CMD_UNSELECT);

    cmd_namespace = IMAP_CMD("namespace", CMD_NAMESPACE);

    command = tag >> dSP >> BSP::access_node_d[BSP::root_node_d[(
                                command_select | command_auth | command_nonauth | command_any)]]
                                              [set_id(yimap::lex_ids::COMMAND)] >>
        dCRLF;

    command_any = cmd_capability | cmd_id | cmd_logout | cmd_noop;

    command_auth = cmd_append | cmd_create | cmd_delete | cmd_enable | cmd_examine | cmd_idle |
        cmd_list | cmd_x_list | cmd_lsub | cmd_namespace | cmd_rename | cmd_select | cmd_status |
        cmd_subscribe | cmd_unsubscribe;

    command_nonauth = cmd_login | cmd_authenticate | cmd_starttls;

    command_select = cmd_check | cmd_unselect | cmd_close | cmd_expunge | cmd_copy | cmd_move |
        cmd_fetch | cmd_store | cmd_uid | cmd_search;

    continue_req = ch_p('+') >> dSP >> (resp_text | base64) >> dCRLF;

    cmd_copy = IMAP_CMD("copy", CMD_COPY) >> dSP >> sequence_set >> dSP >> mailbox;

    cmd_move = IMAP_CMD("move", CMD_MOVE) >> dSP >> sequence_set >> dSP >> mailbox;

    cmd_create = IMAP_CMD("create", CMD_CREATE) >> dSP >> mailbox;

    cmd_delete = IMAP_CMD("delete", CMD_DELETE) >> dSP >> mailbox;

    digit_nz = range_p('1', '9');

    envelope = LPAR >> env_date >> dSP >> env_subject >> env_from >> dSP >> env_sender >> dSP >>
        env_reply_to >> dSP >> env_to >> dSP >> env_cc >> dSP >> env_bcc >> dSP >>
        env_in_reply_to >> dSP >> env_message_id >> RPAR;
    env_bcc = (LPAR >> +address >> RPAR) | nil;
    env_cc = (LPAR >> +address >> RPAR) | nil;
    env_date = nstring;
    env_from = (LPAR >> +address >> RPAR) | nil;
    env_in_reply_to = nstring;
    env_message_id = nstring;
    env_reply_to = (LPAR >> +address >> RPAR) | nil;
    env_sender = (LPAR >> +address >> RPAR) | nil;
    env_subject = nstring;
    env_to = (LPAR >> +address >> RPAR) | nil;

    cmd_enable = IMAP_CMD("enable", CMD_ENABLE) >> dSP >> list_p(astring, dSP);

    cmd_examine = IMAP_CMD("examine", CMD_EXAMINE) >> dSP >> mailbox;

    cmd_expunge = IMAP_CMD("expunge", CMD_EXPUNGE);

    cmd_uid_expunge = IMAP_CMD("expunge", CMD_UID_EXPUNGE) >> dSP >> sequence_set;

    cmd_fetch =
        IMAP_CMD("fetch", CMD_FETCH) >> dSP >> sequence_set >> dSP >> gen_pt_node_d[fetch_atts];
    //                fetch_att | (LPAR >> fetch_att >> *(dSP >> fetch_att) >> RPAR));

    fetch_macro = SET_ID(FETCH_MACRO_ALL, as_lower_d["all"]) |
        SET_ID(FETCH_MACRO_FULL, as_lower_d["full"]) | SET_ID(FETCH_MACRO_FAST, as_lower_d["fast"]);

    fetch_atts = gen_ast_node_d
        [fetch_macro | fetch_att |
         (BSP::discard_node_d[LPAR] >> list_p(fetch_att, dSP) >> BSP::discard_node_d[RPAR])];

    fetch_att = SET_ID(FETCH_ATT_ENVELOPE, as_lower_d["envelope"]) |
        SET_ID(FETCH_ATT_FLAGS, as_lower_d["flags"]) |
        SET_ID(FETCH_ATT_INTERNALDATE, as_lower_d["internaldate"]) |
        SET_ID(FETCH_ATT_RFC822_HEADER, as_lower_d["rfc822.header"]) |
        SET_ID(FETCH_ATT_RFC822_SIZE, as_lower_d["rfc822.size"]) |
        SET_ID(FETCH_ATT_RFC822_TEXT, as_lower_d["rfc822.text"]) |
        SET_ID(FETCH_ATT_RFC822, as_lower_d["rfc822"]) | SET_ID(FETCH_ATT_UID, as_lower_d["uid"]) |
        SET_ID(FETCH_ATT_XMID, as_lower_d["xmid"]) | SET_ID(FETCH_ATT_XSTID, as_lower_d["xstid"]) |
        SET_ID(FETCH_ATT_BODY_STRUCTURE, BSP::root_node_d[as_lower_d["bodystructure"]]) |
        (SET_ID(FETCH_ATT_BODY_PEEK, BSP::root_node_d[as_lower_d["body.peek"]]) >>
         section_with_range >> !section_range) |
        (SET_ID(
            FETCH_ATT_BODY,
            BSP::root_node_d[as_lower_d["body"]] >> section_with_range >> !section_range)) |
        SET_ID(FETCH_ATT_BODY_STRUCTURE_NONEXT, as_lower_d["body"]) |
        (SET_ID(FETCH_ATT_BINARY_PEEK, BSP::root_node_d[as_lower_d["binary.peek"]]) >>
         section_with_range >> !section_range) |
        (SET_ID(FETCH_ATT_BINARY_SIZE, BSP::root_node_d[as_lower_d["binary.size"]]) >>
         section_with_range) |
        (SET_ID(
            FETCH_ATT_BINARY,
            BSP::root_node_d[as_lower_d["binary"]] >> section_with_range >> !section_range));

    section_with_range = gen_ast_node_d[section]; //  >> !section_range;

    section_range = BSP::discard_node_d[ch_p('<')] >> number >> BSP::discard_node_d[ch_p('.')] >>
        nz_number >> BSP::discard_node_d[ch_p('>')];

    // does not include "\recent"
    flag = as_lower_d["\\answered"] | as_lower_d["\\flagged"] | as_lower_d["\\deleted"] |
        as_lower_d["\\seen"] | as_lower_d["\\draft"] | token_node_d[flag_extension] |
        token_node_d[flag_keyword];

    flag_extension = ch_p('\\') >> (atom - as_lower_d["recent"]);

    flag_fetch = flag | as_lower_d["\\recent"];

    flag_keyword = token_node_d[+(ATOM_CHAR | ']')];

    flag_list = discard_node_d[LPAR] >> !list_p(flag, dSP) >> discard_node_d[RPAR];

    flag_perm = flag | str_p("\\*");

    greeting = ch_p('*') >> dSP >> (resp_cond_auth | resp_cond_bye) >> dCRLF;

    header_fld_name = SET_ID(HEADER_FLD_NAME, astring);

    header_list = BSP::discard_node_d[LPAR] >> list_p(header_fld_name, dSP) >>
        SET_ID(HEADER_LIST, BSP::discard_node_d[RPAR])

        ;

    cmd_list = IMAP_CMD("list", CMD_LIST) >> dSP >> mailbox >> dSP >> list_mailbox;

    cmd_x_list = IMAP_CMD("xlist", CMD_X_LIST) >> dSP >> mailbox >> dSP >> list_mailbox;

    list_mailbox = BSP::token_node_d[+list_char] | string;

    list_char = ATOM_CHAR | list_wildcards | resp_specials;

    list_wildcards = chset_p("%*");

    cmd_login = IMAP_CMD("login", CMD_LOGIN) >> dSP >> userid >> dSP >> password;

    cmd_logout = IMAP_CMD("logout", CMD_LOGOUT);

    cmd_lsub = IMAP_CMD("lsub", CMD_LSUB) >> dSP >> mailbox >> dSP >> list_mailbox;

    mailbox = access_node_d[astring][set_id(lex_ids::MAILBOX)];

    mailbox_data = (as_lower_d["flags"] >> dSP >> flag_list) |
        (as_lower_d["list"] >> dSP >> mailbox_list) |
        (as_lower_d["search"] >> *(dSP >> nz_number)) |
        (as_lower_d["status"] >> dSP >> mailbox >> dSP >> LPAR >> status_att_list >> RPAR) |
        (number >> dSP >> as_lower_d["exists"]) | (number >> dSP >> as_lower_d["recent"]);

    mailbox_list = LPAR >> !mbx_list_flags >> RPAR >> dSP >>
        ((DQUOTE >> QUOTED_CHAR >> DQUOTE) | nil) >> dSP >> mailbox;

    mbx_list_flags = (*(mbx_list_oflag >> dSP) >> mbx_list_sflag >> *(dSP >> mbx_list_oflag)) |
        list_p(mbx_list_oflag, dSP);

    mbx_list_oflag = as_lower_d["\\noinferiors"] | flag_extension;

    mbx_list_sflag = as_lower_d["\\noselect"] | as_lower_d["\\marked"] | as_lower_d["\\unmarked"];

    media_basic = ((DQUOTE >> (as_lower_d["application"] | as_lower_d["audio"] |
                               as_lower_d["image"] | as_lower_d["message"] | as_lower_d["video"]) >>
                    DQUOTE) |
                   string) >>
        dSP >> media_subtype;

    media_message = DQUOTE >> as_lower_d["message"] >> DQUOTE >> dSP >> DQUOTE >>
        as_lower_d["rfc822"] >> DQUOTE;

    media_subtype = string;

    media_text = DQUOTE >> as_lower_d["text"] >> DQUOTE >> dSP >> media_subtype;

    message_data =
        nz_number >> dSP >> (as_lower_d["expunge"] | (as_lower_d["fetch"] >> dSP >> msg_att));

    msg_att = LPAR >> list_p(msg_att_dynamic | msg_att_static, dSP) >> RPAR;

    msg_att_dynamic = as_lower_d["flags"] >> dSP >> LPAR >> !list_p(flag_fetch, dSP) >> RPAR;

    msg_att_static = (as_lower_d["envelope"] >> dSP >> envelope) |
        (as_lower_d["internaldate"] >> dSP >> date_time_p) |
        (as_lower_d["rfc822"] >> !(as_lower_d[".header"] | as_lower_d[".text"]) >> dSP >> nstring) |
        (as_lower_d["rfc822.size"] >> dSP >> number) |
        (as_lower_d["binary.size"] >> dSP >> number) |
        (as_lower_d["body"] >> !as_lower_d["structure"] >> dSP >> body) |
        (as_lower_d["body"] >> section >> !(ch_p('<') >> number >> ch_p('>')) >> dSP >> nstring) |
        (as_lower_d["uid"] >> dSP >> uniqueid);

    nil = as_lower_d["nil"];

    nstring = string | nil;

    cmd_noop = IMAP_CMD("noop", CMD_NOOP);

    cmd_id = IMAP_CMD("id", CMD_ID) >> dSP >> id_params_list;

    id_params_list =
        (BSP::discard_node_d[LPAR] >> gen_pt_node_d[list_p(astring >> dSP >> nstring, dSP)] >>
         BSP::discard_node_d[RPAR]) |
        nil;

    cmd_idle = IMAP_CMD("idle", CMD_IDLE);

    // number
    number = access_value_d[max_limit_d(
        0xffffffffu)[uint10_p[number.value = arg1] // [number.value = arg1 ]
    ]][number.value]

        ;

    nz_number = access_value_d[min_limit_d(1u)[uint10_p[nz_number.value = arg1]]][nz_number.value];

    password = SET_ID(PASSWORD, astring);

    quoted = BSP::discard_node_d[DQUOTE] >> BSP::token_node_d[*QUOTED_CHAR] >>
        BSP::discard_node_d[DQUOTE];

    QUOTED_CHAR = (TEXT_CHAR - quoted_specials) | (ch_p('\\') >> quoted_specials);

    quoted_specials = DQUOTE | ch_p('\\');

    cmd_rename = IMAP_CMD("rename", CMD_RENAME) >> dSP >> mailbox >> dSP >> mailbox;

    response = *(continue_req | response_data) >> response_done;

    response_data = ch_p('*') >> dSP >>
        (resp_cond_state | resp_cond_bye | mailbox_data | capability_data) >> dCRLF;

    response_done = response_tagged | response_fatal;

    response_fatal = ch_p('*') >> dSP >> resp_cond_bye >> dCRLF;

    response_tagged = tag >> dSP >> resp_cond_state >> dCRLF;

    resp_cond_auth = (as_lower_d["ok"] | as_lower_d["preauth"]) >> dSP >> resp_text;

    resp_cond_bye = as_lower_d["bye"] >> dSP >> resp_text;

    resp_cond_state = (as_lower_d["ok"] | as_lower_d["no"] | as_lower_d["bad"]) >> dSP >> resp_text;

    resp_specials = ch_p(']');

    resp_text = !(ch_p('[') >> resp_text_code >> ch_p(']') >> dSP) >> text;

    resp_text_code = as_lower_d["alert"] |
        (as_lower_d["badcharset"] >> !(dSP >> LPAR >> list_p(astring, dSP) >> RPAR)) |
        capability_data | as_lower_d["parse"] |
        (as_lower_d["permanentflags"] >> dSP >> LPAR >> list_p(flag_perm, dSP) >> RPAR) |
        as_lower_d["read-only"] | as_lower_d["read_write"] | as_lower_d["trycreate"] |
        (as_lower_d["uidnext"] >> dSP >> nz_number) |
        (as_lower_d["uidvalidity"] >> dSP >> nz_number) |
        (as_lower_d["unseen"] >> dSP >> nz_number) | (atom >> (dSP >> +(TEXT_CHAR - ch_p(']'))));

    cmd_search = IMAP_CMD("search", CMD_SEARCH) >>
        !(dSP >> discard_node_d[as_lower_d["charset"]] >> dSP >> SET_ID(SEARCH_CHARSET, astring)) >>
        gen_pt_node_d[search_key_list];

    search_key_list = +(dSP >> search_key);

    date_p = date_text_p | (discard_node_d[DQUOTE] >> date_text_p >> discard_node_d[DQUOTE]);

    search_key_bcc = discard_node_d[as_lower_d["bcc"]] >> dSP >> astring;
    search_key_before = discard_node_d[as_lower_d["before"]] >> dSP >> date_p;
    search_key_body = discard_node_d[as_lower_d["body"]] >> dSP >> astring;
    search_key_cc = discard_node_d[as_lower_d["cc"]] >> dSP >> astring;
    search_key_from = discard_node_d[as_lower_d["from"]] >> dSP >> astring;
    search_key_keyword = discard_node_d[as_lower_d["keyword"]] >> dSP >> flag_keyword;
    search_key_on = discard_node_d[as_lower_d["on"]] >> dSP >> date_p;

    search_key_since =
        discard_node_d[as_lower_d["since"]] >> dSP >> date_p // [search_key_since.dmy = arg1]
        ;
    search_key_subject = discard_node_d[as_lower_d["subject"]] >> dSP >> astring;
    search_key_text = discard_node_d[as_lower_d["text"]] >> dSP >> astring;
    search_key_to = discard_node_d[as_lower_d["to"]] >> dSP >> astring;
    search_key_unkeyword = discard_node_d[as_lower_d["unkeyword"]] >> dSP >> flag_keyword;
    search_key_larger = discard_node_d[as_lower_d["larger"]] >> dSP >> number;
    search_key_sentbefore = discard_node_d[as_lower_d["sentbefore"]] >> dSP >> date_p;
    search_key_senton = discard_node_d[as_lower_d["senton"]] >> dSP >> date_p;
    search_key_sentsince = discard_node_d[as_lower_d["sentsince"]] >> dSP >> date_p;
    search_key_smaller = discard_node_d[as_lower_d["smaller"]] >> dSP >> number;
    search_key_uid = discard_node_d[as_lower_d["uid"]] >> dSP >> sequence_set;

    search_key_group = discard_node_d[LPAR]
        // >> BSP::gen_pt_node_d[ search_key_grp ]
        // >> *( dSP >> BSP::gen_pt_node_d[ search_key_grp ])
        >> list_p(search_key_grp, dSP) >> discard_node_d[RPAR];

    search_key_grp = BSP::gen_ast_node_d[search_key];

    search_key_header =
        discard_node_d[as_lower_d["header"]] >> dSP >> header_fld_name >> dSP >> astring;

    search_key_or = discard_node_d[as_lower_d["or"]] >> dSP >> search_key >> dSP >> search_key;

    search_key_not = discard_node_d[as_lower_d["not"]] >> dSP >> BSP::gen_pt_node_d[search_key];

    search_key = SET_ID(SEARCH_KEY_ALL, as_lower_d["all"]) |
        SET_ID(SEARCH_KEY_ANSWERED, as_lower_d["answered"]) |
        SET_ID(SEARCH_KEY_BCC, search_key_bcc) | SET_ID(SEARCH_KEY_BEFORE, search_key_before) |
        SET_ID(SEARCH_KEY_BODY, search_key_body) | SET_ID(SEARCH_KEY_CC, search_key_cc) |
        SET_ID(SEARCH_KEY_DELETED, as_lower_d["deleted"]) |
        SET_ID(SEARCH_KEY_FLAGGED, as_lower_d["flagged"]) |
        SET_ID(SEARCH_KEY_FROM, search_key_from) | SET_ID(SEARCH_KEY_KEYWORD, search_key_keyword) |
        SET_ID(SEARCH_KEY_NEW, as_lower_d["new"]) | SET_ID(SEARCH_KEY_OLD, as_lower_d["old"]) |
        SET_ID(SEARCH_KEY_ON, search_key_on) | SET_ID(SEARCH_KEY_RECENT, as_lower_d["recent"]) |
        SET_ID(SEARCH_KEY_SEEN, as_lower_d["seen"]) | SET_ID(SEARCH_KEY_SINCE, search_key_since) |
        SET_ID(SEARCH_KEY_SUBJECT, search_key_subject) | SET_ID(SEARCH_KEY_TEXT, search_key_text) |
        SET_ID(SEARCH_KEY_TO, search_key_to) |
        SET_ID(SEARCH_KEY_UNANSWERED, as_lower_d["unanswered"]) |
        SET_ID(SEARCH_KEY_UNDELETED, as_lower_d["undeleted"]) |
        SET_ID(SEARCH_KEY_UNFLAGGED, as_lower_d["unflagged"]) |
        SET_ID(SEARCH_KEY_UNKEYWORD, search_key_unkeyword) |
        SET_ID(SEARCH_KEY_UNSEEN, as_lower_d["unseen"]) |
        SET_ID(SEARCH_KEY_DRAFT, as_lower_d["draft"]) |
        SET_ID(SEARCH_KEY_HEADER, search_key_header) |
        SET_ID(SEARCH_KEY_LARGER, search_key_larger) | SET_ID(SEARCH_KEY_NOT, search_key_not) |
        SET_ID(SEARCH_KEY_OR, search_key_or) |
        SET_ID(SEARCH_KEY_SENTBEFORE, search_key_sentbefore) |
        SET_ID(SEARCH_KEY_SENTON, search_key_senton) |
        SET_ID(SEARCH_KEY_SENTSINCE, search_key_sentsince) |
        SET_ID(SEARCH_KEY_SMALLER, search_key_smaller) | SET_ID(SEARCH_KEY_UID, search_key_uid) |
        SET_ID(SEARCH_KEY_UNDRAFT, as_lower_d["undraft"]) |
        SET_ID(SEARCH_KEY_SEQSET, sequence_set) |
        SET_ID(SEARCH_KEY_AND, BSP::gen_pt_node_d[search_key_group]);

    section = BSP::discard_node_d[ch_p('[')] >> !section_spec >> BSP::discard_node_d[ch_p(']')];

    section_msgtext =
        ((SET_ID(SECTION_MSG_HEADER_FIELDS_NOT, BSP::root_node_d[as_lower_d["header.fields.not"]]) |
          SET_ID(SECTION_MSG_HEADER_FIELDS, BSP::root_node_d[as_lower_d["header.fields"]])) >>
         dSP
         //        >> gen_ast_node_d[ header_list ]
         >> BSP::discard_node_d[LPAR] >> gen_ast_node_d[list_p(header_fld_name, dSP)] >>
         SET_ID(HEADER_LIST, BSP::discard_node_d[RPAR])) |
        SET_ID(SECTION_MSG_HEADER, as_lower_d["header"]) |
        SET_ID(SECTION_MSG_TEXT, as_lower_d["text"]);

    section_part = token_node_d[nz_number >> *(ch_p('.') >> nz_number)];

    section_spec = section_msgtext |
        (section_part >> !(discard_node_d[ch_p('.')] >> root_node_d[section_text]));

    section_text = section_msgtext | SET_ID(SECTION_TEXT_MIME, as_lower_d["mime"])
        // | SET_ID (SECTION, eps_p)
        ;

    cmd_select = IMAP_CMD("select", CMD_SELECT) >> dSP >> mailbox;

    seq_number = SET_ID(SEQ_NUMBER, nz_number) | SET_ID(SEQ_NUMBER_LAST, ch_p('*'));

    seq_range = seq_number >> BSP::discard_node_d[ch_p(':')] >> seq_number;

    sequence_set =
        access_node_d[BSP::gen_pt_node_d[sequence_set_tmp]][set_id(lex_ids::SEQUENCE_SET)];

    sequence_set_tmp =
        BSP::list_p(SET_ID(SEQ_RANGE, seq_range) | seq_number, BSP::discard_node_d[BSP::ch_p(',')]);

    cmd_starttls = IMAP_CMD("starttls", CMD_STARTTLS);

    cmd_status = IMAP_CMD("status", CMD_STATUS) >> dSP >> mailbox >> dSP >>
        BSP::discard_node_d[LPAR] >> gen_pt_node_d[status_atts] >> BSP::discard_node_d[RPAR];

    status_atts = list_p(status_att, dSP);
    status_att = SET_ID(STATUS_ATT_MESSAGES, as_lower_d["messages"]) |
        SET_ID(STATUS_ATT_RECENT, as_lower_d["recent"]) |
        SET_ID(STATUS_ATT_UIDNEXT, as_lower_d["uidnext"]) |
        SET_ID(STATUS_ATT_UIDVALIDITY, as_lower_d["uidvalidity"]) |
        SET_ID(STATUS_ATT_UNSEEN, as_lower_d["unseen"]);

    status_att_list = list_p(status_att >> dSP >> number, dSP);

    cmd_store = IMAP_CMD("store", CMD_STORE) >> dSP >> sequence_set >> dSP >>
        (SET_ID(STORE_ATT_ADD_FLAGS, as_lower_d["+flags"]) |
         SET_ID(STORE_ATT_DEL_FLAGS, as_lower_d["-flags"]) |
         SET_ID(STORE_ATT_SET_FLAGS, as_lower_d["flags"])) >>
        (SET_ID(STORE_ATT_SILENT, gen_pt_node_d[as_lower_d[".silent"] >> dSP]) |
         SET_ID(STORE_ATT_VERBOSE, gen_pt_node_d[SP])) >>
        gen_pt_node_d[store_att_flags_list];

    store_att_flags_list =
        (discard_node_d[LPAR] >> !list_p(flag, dSP) >> discard_node_d[RPAR]) | list_p(flag, dSP);

    string = access_value_d[quoted][PH::val((int)LEX_QUOTED)] |
        access_value_d[literal_p][PH::val((int)LEX_LITERAL)];

    cmd_subscribe = IMAP_CMD("subscribe", CMD_SUBSCRIBE) >> dSP >> mailbox;

    tag = BSP::token_node_d[+(ASTRING_CHAR - ch_p('+'))];

    text = +TEXT_CHAR;

    TEXT_CHAR = anychar_p - eol_p;

    // uint_parser<unsigned, 10, 2, 2> uint2_2_p;

    cmd_uid = IMAP_CMD("uid", CMD_UID) >> dSP >>
        (cmd_copy | cmd_move | cmd_fetch | cmd_search | cmd_store | cmd_uid_expunge);

    uniqueid = nz_number;

    cmd_unsubscribe = IMAP_CMD("unsubscribe", CMD_UNSUBSCRIBE) >> dSP >> mailbox;

    userid = astring // [userid.value = arg1]
        ;

    // x_command =
    //  cmd_x_debug |
    //  (chset_p("xX") >> atom >> *(anychar_p - dCRLF));

    top = command;

    BOOST_SPIRIT_DEBUG_RULE(address);
    BOOST_SPIRIT_DEBUG_RULE(addr_adl);
    BOOST_SPIRIT_DEBUG_RULE(addr_host);
    BOOST_SPIRIT_DEBUG_RULE(addr_mailbox);
    BOOST_SPIRIT_DEBUG_RULE(addr_name);
    BOOST_SPIRIT_DEBUG_RULE(astring);
    BOOST_SPIRIT_DEBUG_RULE(ASTRING_CHAR);
    BOOST_SPIRIT_DEBUG_RULE(atom);
    BOOST_SPIRIT_DEBUG_RULE(ATOM_CHAR);
    BOOST_SPIRIT_DEBUG_RULE(atom_specials);
    BOOST_SPIRIT_DEBUG_RULE(auth_type);
    BOOST_SPIRIT_DEBUG_RULE(base64);
    BOOST_SPIRIT_DEBUG_RULE(base64_char);
    BOOST_SPIRIT_DEBUG_RULE(base64_terminal);
    BOOST_SPIRIT_DEBUG_RULE(body);
    BOOST_SPIRIT_DEBUG_RULE(body_extension);
    BOOST_SPIRIT_DEBUG_RULE(body_ext_1part);
    BOOST_SPIRIT_DEBUG_RULE(body_ext_mpart);
    BOOST_SPIRIT_DEBUG_RULE(body_fields);
    BOOST_SPIRIT_DEBUG_RULE(body_fld_desc);
    BOOST_SPIRIT_DEBUG_RULE(body_fld_dsp);
    BOOST_SPIRIT_DEBUG_RULE(body_fld_enc);
    BOOST_SPIRIT_DEBUG_RULE(body_fld_id);
    BOOST_SPIRIT_DEBUG_RULE(body_fld_lang);
    BOOST_SPIRIT_DEBUG_RULE(body_fld_loc);
    BOOST_SPIRIT_DEBUG_RULE(body_fld_lines);
    BOOST_SPIRIT_DEBUG_RULE(body_fld_md5);
    BOOST_SPIRIT_DEBUG_RULE(body_fld_octets);
    BOOST_SPIRIT_DEBUG_RULE(body_fld_param);
    BOOST_SPIRIT_DEBUG_RULE(body_type_1part);
    BOOST_SPIRIT_DEBUG_RULE(body_type_basic);
    BOOST_SPIRIT_DEBUG_RULE(body_type_mpart);
    BOOST_SPIRIT_DEBUG_RULE(body_type_msg);
    BOOST_SPIRIT_DEBUG_RULE(body_type_text);
    BOOST_SPIRIT_DEBUG_RULE(capability);
    BOOST_SPIRIT_DEBUG_RULE(capability_data);
    BOOST_SPIRIT_DEBUG_RULE(CHAR8);
    BOOST_SPIRIT_DEBUG_RULE(command);
    BOOST_SPIRIT_DEBUG_RULE(command_any);
    BOOST_SPIRIT_DEBUG_RULE(command_auth);
    BOOST_SPIRIT_DEBUG_RULE(command_nonauth);
    BOOST_SPIRIT_DEBUG_RULE(command_select);
    BOOST_SPIRIT_DEBUG_RULE(continue_req);
    BOOST_SPIRIT_DEBUG_RULE(digit_nz);
    BOOST_SPIRIT_DEBUG_RULE(envelope);
    BOOST_SPIRIT_DEBUG_RULE(env_bcc);
    BOOST_SPIRIT_DEBUG_RULE(env_cc);
    BOOST_SPIRIT_DEBUG_RULE(env_date);
    BOOST_SPIRIT_DEBUG_RULE(env_from);
    BOOST_SPIRIT_DEBUG_RULE(env_in_reply_to);
    BOOST_SPIRIT_DEBUG_RULE(env_message_id);
    BOOST_SPIRIT_DEBUG_RULE(env_reply_to);
    BOOST_SPIRIT_DEBUG_RULE(env_sender);
    BOOST_SPIRIT_DEBUG_RULE(env_subject);
    BOOST_SPIRIT_DEBUG_RULE(env_to);
    BOOST_SPIRIT_DEBUG_RULE(expunge_command);
    BOOST_SPIRIT_DEBUG_RULE(expunge_uid_command);
    BOOST_SPIRIT_DEBUG_RULE(fetch_att);
    BOOST_SPIRIT_DEBUG_RULE(fetch_atts);
    BOOST_SPIRIT_DEBUG_RULE(flag);
    BOOST_SPIRIT_DEBUG_RULE(flag_extension);
    BOOST_SPIRIT_DEBUG_RULE(flag_fetch);
    BOOST_SPIRIT_DEBUG_RULE(flag_keyword);
    BOOST_SPIRIT_DEBUG_RULE(flag_list);
    BOOST_SPIRIT_DEBUG_RULE(flag_perm);
    BOOST_SPIRIT_DEBUG_RULE(greeting);
    BOOST_SPIRIT_DEBUG_RULE(header_fld_name);
    BOOST_SPIRIT_DEBUG_RULE(header_list);
    BOOST_SPIRIT_DEBUG_RULE(list);
    BOOST_SPIRIT_DEBUG_RULE(list_mailbox);
    BOOST_SPIRIT_DEBUG_RULE(list_char);
    BOOST_SPIRIT_DEBUG_RULE(list_wildcards);
    BOOST_SPIRIT_DEBUG_RULE(mailbox);
    BOOST_SPIRIT_DEBUG_RULE(mailbox_data);
    BOOST_SPIRIT_DEBUG_RULE(mailbox_list);
    BOOST_SPIRIT_DEBUG_RULE(mbx_list_flags);
    BOOST_SPIRIT_DEBUG_RULE(mbx_list_oflag);
    BOOST_SPIRIT_DEBUG_RULE(mbx_list_sflag);
    BOOST_SPIRIT_DEBUG_RULE(media_basic);
    BOOST_SPIRIT_DEBUG_RULE(media_message);
    BOOST_SPIRIT_DEBUG_RULE(media_subtype);
    BOOST_SPIRIT_DEBUG_RULE(media_text);
    BOOST_SPIRIT_DEBUG_RULE(message_data);
    BOOST_SPIRIT_DEBUG_RULE(msg_att);
    BOOST_SPIRIT_DEBUG_RULE(msg_att_dynamic);
    BOOST_SPIRIT_DEBUG_RULE(msg_att_static);
    BOOST_SPIRIT_DEBUG_RULE(nil);
    BOOST_SPIRIT_DEBUG_RULE(nstring);
    BOOST_SPIRIT_DEBUG_RULE(number);
    BOOST_SPIRIT_DEBUG_RULE(nz_number);
    BOOST_SPIRIT_DEBUG_RULE(password);
    BOOST_SPIRIT_DEBUG_RULE(quoted);
    BOOST_SPIRIT_DEBUG_RULE(QUOTED_CHAR);
    BOOST_SPIRIT_DEBUG_RULE(quoted_specials);
    BOOST_SPIRIT_DEBUG_RULE(response);
    BOOST_SPIRIT_DEBUG_RULE(response_data);
    BOOST_SPIRIT_DEBUG_RULE(response_done);
    BOOST_SPIRIT_DEBUG_RULE(response_fatal);
    BOOST_SPIRIT_DEBUG_RULE(response_tagged);
    BOOST_SPIRIT_DEBUG_RULE(resp_cond_auth);
    BOOST_SPIRIT_DEBUG_RULE(resp_cond_bye);
    BOOST_SPIRIT_DEBUG_RULE(resp_cond_state);
    BOOST_SPIRIT_DEBUG_RULE(resp_specials);
    BOOST_SPIRIT_DEBUG_RULE(resp_text);
    BOOST_SPIRIT_DEBUG_RULE(resp_text_code);
    BOOST_SPIRIT_DEBUG_RULE(search_key);
    BOOST_SPIRIT_DEBUG_RULE(section);
    BOOST_SPIRIT_DEBUG_RULE(section_msgtext);
    BOOST_SPIRIT_DEBUG_RULE(section_part);
    BOOST_SPIRIT_DEBUG_RULE(section_spec);
    BOOST_SPIRIT_DEBUG_RULE(section_text);
    BOOST_SPIRIT_DEBUG_RULE(section_range);
    BOOST_SPIRIT_DEBUG_RULE(section_with_range);
    BOOST_SPIRIT_DEBUG_RULE(seq_number);
    BOOST_SPIRIT_DEBUG_RULE(seq_range);
    BOOST_SPIRIT_DEBUG_RULE(sequence_set_tmp);
    BOOST_SPIRIT_DEBUG_RULE(sequence_set);
    BOOST_SPIRIT_DEBUG_RULE(status_att);
    BOOST_SPIRIT_DEBUG_RULE(status_atts);
    BOOST_SPIRIT_DEBUG_RULE(status_att_list);
    BOOST_SPIRIT_DEBUG_RULE(store_att_flags);
    BOOST_SPIRIT_DEBUG_RULE(string);
    BOOST_SPIRIT_DEBUG_RULE(tag);
    BOOST_SPIRIT_DEBUG_RULE(text);
    BOOST_SPIRIT_DEBUG_RULE(TEXT_CHAR);
    BOOST_SPIRIT_DEBUG_RULE(uniqueid);
    BOOST_SPIRIT_DEBUG_RULE(userid);
    // BOOST_SPIRIT_DEBUG_RULE(x_command);
    BOOST_SPIRIT_DEBUG_RULE(cmd_capability);
    BOOST_SPIRIT_DEBUG_RULE(cmd_logout);
    BOOST_SPIRIT_DEBUG_RULE(cmd_noop);
    BOOST_SPIRIT_DEBUG_RULE(cmd_idle);
    BOOST_SPIRIT_DEBUG_RULE(cmd_append);
    BOOST_SPIRIT_DEBUG_RULE(cmd_create);
    BOOST_SPIRIT_DEBUG_RULE(cmd_delete);
    BOOST_SPIRIT_DEBUG_RULE(cmd_examine);
    BOOST_SPIRIT_DEBUG_RULE(cmd_list);
    BOOST_SPIRIT_DEBUG_RULE(cmd_x_list);
    BOOST_SPIRIT_DEBUG_RULE(cmd_lsub);
    BOOST_SPIRIT_DEBUG_RULE(cmd_rename);
    BOOST_SPIRIT_DEBUG_RULE(cmd_select);
    BOOST_SPIRIT_DEBUG_RULE(cmd_status);
    BOOST_SPIRIT_DEBUG_RULE(cmd_subscribe);
    BOOST_SPIRIT_DEBUG_RULE(cmd_unsubscribe);
    BOOST_SPIRIT_DEBUG_RULE(cmd_login);
    BOOST_SPIRIT_DEBUG_RULE(cmd_authenticate);
    BOOST_SPIRIT_DEBUG_RULE(cmd_starttls);
    BOOST_SPIRIT_DEBUG_RULE(cmd_check);
    BOOST_SPIRIT_DEBUG_RULE(cmd_close);
    BOOST_SPIRIT_DEBUG_RULE(cmd_unselect);
    BOOST_SPIRIT_DEBUG_RULE(cmd_expunge);
    BOOST_SPIRIT_DEBUG_RULE(cmd_uid_expunge);
    BOOST_SPIRIT_DEBUG_RULE(cmd_copy);
    BOOST_SPIRIT_DEBUG_RULE(cmd_move);
    BOOST_SPIRIT_DEBUG_RULE(cmd_fetch);
    BOOST_SPIRIT_DEBUG_RULE(cmd_store);
    BOOST_SPIRIT_DEBUG_RULE(cmd_uid);
    BOOST_SPIRIT_DEBUG_RULE(cmd_search);
    BOOST_SPIRIT_DEBUG_RULE(cmd_x_debug);
    BOOST_SPIRIT_DEBUG_RULE(cmd_namespace);
    BOOST_SPIRIT_DEBUG_RULE(CTL);
}

}}     // namespace yimap::parser
#endif //
