#ifndef _YIMAP_PARSER_PARSER_H_
#define _YIMAP_PARSER_PARSER_H_
#include <common/types.h>
#include <common/zerocopy.h>

#include <yplatform/active/object.h>
#include <yplatform/task_context.h>

#include <boost/asio.hpp>
#include <common/tree.h>

namespace yimap {
namespace parser {

class parser : public yplatform::active::object
{
public:
    typedef TreeIterator const_iterator;

protected:
    parser() : yplatform::active::object()
    {
    }
    virtual ~parser()
    {
    }

public:
    virtual Future<CommandASTPtr> parse(
        yplatform::task_context_ptr ctx,
        const zerocopy::SegmentRange& data,
        const yplatform::active::ptime& deadline = boost::posix_time::pos_infin) = 0;
};

}

namespace YP = ::yimap::parser;

}

#endif // _YIMAP_PARSER_PARSER_H_
