#ifndef _YIMAP_RFC822_RFC2822_TYPES_H_
#define _YIMAP_RFC822_RFC2822_TYPES_H_

#if defined(BOOST_SPIRIT_DEBUG)
#include <ostream>
#endif

#include <time.h>
#include <functional>
#include <deque>
#include <boost/shared_ptr.hpp>
#include <yplatform/iterator_range.h>

namespace yimap { namespace rfc822 { namespace rfc2822 {

using std::string;

struct time_type
{
    unsigned short hour;
    unsigned short minute;
    unsigned short second;
    int zone;
};

struct date_type
{
    unsigned short mday;
    unsigned short month;
    short year;
};

struct date_time_type
{
    time_t gmtime;
    unsigned int zone;
};

struct AddressType
{
    inline AddressType() : name(), local(), domain()
    {
    }

    inline AddressType(const string& n, const string& l, const string& d)
        : name(n), local(l), domain(d)
    {
    }

    inline AddressType(const string& l, const string& d) : name(), local(l), domain(d)
    {
    }

    inline AddressType(const string& n) : name(n), local(), domain()
    {
    }

    string name;
    string local;
    string domain;
};

struct BaseFieldValue
{
    BaseFieldValue()
    {
    }
    BaseFieldValue(const string& rng) : raw(rng)
    {
    }
    virtual ~BaseFieldValue()
    {
    }

    string raw;
};

struct FieldValuePtr : public boost::shared_ptr<BaseFieldValue>
{
    typedef boost::shared_ptr<BaseFieldValue> base_;
    FieldValuePtr() : base_()
    {
    }

    template <typename U>
    FieldValuePtr(U* u) : base_(u)
    {
    }
};

struct FieldData
{
    string raw;
    string name;
    FieldValuePtr value;
};

struct datetime_field_value : public BaseFieldValue
{
    date_time_type date_time;
};

/////////////////////////////////////////////////////////////////////////
struct AddressList : std::deque<AddressType>
{
};

inline AddressList& operator+=(AddressList& lhs, const AddressList& rhs)
{
    lhs.insert(lhs.end(), rhs.begin(), rhs.end());
    return lhs;
}

inline AddressList& operator+=(AddressList& lhs, const AddressType& rhs)
{
    lhs.push_back(rhs);
    return lhs;
}

/////////////////////////////////////////////////////////////////////////

struct mime_parameter
{
    mime_parameter()
    {
    }
    mime_parameter(const string& a) : attr(a)
    {
    }
    mime_parameter(const string& a, const string& v) : attr(a), value(v)
    {
    }

    string attr;
    string value;
};

/////////////////////////////////////////////////////////////////////////

struct MimeParameterList : std::deque<mime_parameter>
{
};

inline MimeParameterList& operator+=(MimeParameterList& lhs, const MimeParameterList& rhs)
{
    lhs.insert(lhs.end(), rhs.begin(), rhs.end());
    return lhs;
}

inline MimeParameterList& operator+=(MimeParameterList& lhs, const mime_parameter& rhs)
{
    lhs.push_back(rhs);
    return lhs;
}

/////////////////////////////////////////////////////////////////////////
struct mime_content_type
{
    mime_content_type()
    {
    }
    mime_content_type(const string& t, const string& s) : type(t), subtype(s)
    {
    }

    string type;
    string subtype;
};

/////////////////////////////////////////////////////////////////////////

struct mime_content_type_field_value : public BaseFieldValue
{
    mime_content_type_field_value()
    {
    }
    mime_content_type_field_value(
        const mime_content_type& type,
        const MimeParameterList& list,
        const string& raw)
        : BaseFieldValue(raw), content_type(type), params(list)
    {
    }

    mime_content_type content_type;
    MimeParameterList params;
};

/////////////////////////////////////////////////////////////////////////
struct mime_with_params_field_value : public BaseFieldValue
{
    mime_with_params_field_value()
    {
    }
    mime_with_params_field_value(const string& v) : value(v)
    {
    }
    mime_with_params_field_value(const string& v, const MimeParameterList& p) : value(v), params(p)
    {
    }

    mime_with_params_field_value(const string& v, MimeParameterList const& p, const string& raw)
        : BaseFieldValue(raw), value(v), params(p)
    {
    }

    string value;
    MimeParameterList params;
};

/////////////////////////////////////////////////////////////////////////

struct AddressFieldValue : public BaseFieldValue
{
    AddressFieldValue()
    {
    }
    explicit AddressFieldValue(AddressType const& a, const string& raw)
        : BaseFieldValue(raw), addr(a)
    {
    }

    AddressType addr;
};

/////////////////////////////////////////////////////////////////////////

struct AddressListFieldValue : public BaseFieldValue
{
    AddressListFieldValue()
    {
    }
    explicit AddressListFieldValue(const AddressList& l, const string& raw)
        : BaseFieldValue(raw), addrs(l)
    {
    }

    AddressList addrs;
};

/////////////////////////////////////////////////////////////////////////

struct HeaderList : public std::deque<FieldData>
{
};

inline HeaderList& operator+=(HeaderList& lhs, const HeaderList& rhs)
{
    lhs.insert(lhs.end(), rhs.begin(), rhs.end());
    return lhs;
}

inline HeaderList& operator+=(HeaderList& lhs, const FieldData& rhs)
{
    lhs.push_back(rhs);
    return lhs;
}

}}}
#endif // _YIMAP_RFC822_RFC2822_TYPES_H_
