#pragma once

#include <string>
#include <vector>

#include "rfc2822_types.h"
#include <boost/range.hpp>

namespace yimap { namespace rfc822 {

using namespace yimap::rfc822::rfc2822;

class MessageReactor
{
public:
    typedef string::const_iterator iterator;
    typedef boost::iterator_range<iterator> data_range_t;

    virtual ~MessageReactor()
    {
    }

    virtual void on_field_data(const FieldData& /*fd*/)
    {
    }
    virtual void on_body_prefix(const data_range_t& /*data*/)
    {
    }
    virtual void on_body(const data_range_t& /*data*/)
    {
    }
};

class MessageDataReactor : public MessageReactor
{
public:
    HeaderList header_list_data;
    data_range_t body_prefix{ iterator(), iterator() };
    data_range_t body{ iterator(), iterator() };

    virtual void on_field_data(const FieldData& fd) override
    {
        header_list_data.push_back(fd);
    }

    virtual void on_body_prefix(const data_range_t& data) override
    {
        body_prefix = data;
    }

    virtual void on_body(const data_range_t& data)
    {
        body = data;
    }
};

bool parseMessage(
    const string& data,
    MessageReactor& reactor,
    const std::vector<std::string>& rawHeadersList);

} // namespace rfc822
} // namespace yimap
