#pragma once

#include "read_exec_commands_loop.h"
#include <common/types.h>
#include <network/session.h>
#include <yplatform/coroutine.h>
#include <yplatform/yield.h>

namespace yimap {

using Coroutine = boost::asio::coroutine;

struct ProtocolCoroutine : Coroutine
{
    ImapContextPtr context;
    NetworkSessionPtr session;
    backend::BundlePtr backends;

    void operator()(ErrorCode ec = {})
    {
        if (ec) return;

        reenter(this)
        {
            if (session->endpoint().secure)
            {
                yield asyncSetupTLS();
            }
            sendGreeting();
            yield asyncReadAndExecCommands();
        }
    }

    void asyncSetupTLS()
    {
        session->asyncStartTLS(*this);
    }

    void sendGreeting()
    {
        session->clientStream() << "* OK Yandex IMAP4rev1" // << PACKAGE_VERSION
                                << " at " << context->settings->serverSettings.host_name << ':'
                                << context->sessionInfo.localPort << " ready to talk with "
                                << context->sessionInfo.remoteAddress << ":"
                                << context->sessionInfo.remotePort << ", "
                                << boost::posix_time::to_simple_string(
                                       ::boost::posix_time::second_clock::local_time())
                                << ", " << context->uniq_id() << "\r\n";
    }

    void asyncReadAndExecCommands()
    {
        auto&& executor = context->ioService.get_executor();
        yplatform::spawn(
            executor, std::make_shared<ReadAndExecCommandsLoop>(context, session, backends));
    }
};

}

#include <yplatform/unyield.h>
