#include "typed_log.h"
#include <yplatform/log.h>
#include <yplatform/module.h>
#include <yplatform/find.h>

namespace yimap::typed {

namespace tl = yplatform::log::typed;

tl::attributes_map makeUserAttrs(ImapContextPtr context);
tl::attributes_map makeExtraAttrs(const ExtraStatFields& extra);

void logAuth(ImapContextPtr context, const std::string& status, const std::string& reason)
{
    yplatform::log::tskv_logger log(YGLOBAL_LOG_SERVICE, "typed_log");
    YLOG(log, info) << tl::make_attr("type", "auth") << makeUserAttrs(context)
                    << tl::make_attr("status", status) << tl::make_attr("reason", reason);
}

void logCommandComplete(
    ImapContextPtr context,
    const string& status,
    const string& commandName,
    const string& commandText,
    size_t commandLength,
    const Duration& totalTime,
    const MessagesStats& messagesStats,
    const ExtraStatFields& extra)
{
    auto selectedFolder = context->sessionState.selectedFolder;
    yplatform::log::tskv_logger log(YGLOBAL_LOG_SERVICE, "typed_log");
    YLOG(log, info)
        << tl::make_attr("type", "command") << tl::make_attr("status", status)
        << tl::make_attr("session", context->uniq_id())
        << tl::make_attr("selected_folder_id", selectedFolder ? selectedFolder.fid() : ""s)
        << tl::make_attr("command_name", commandName) << tl::make_attr("command_text", commandText)
        << tl::make_attr("command_length", commandLength)
        << tl::make_attr(
               "messages_loaded_from_metabackend_count", messagesStats.loadedFromMetabackendCount)
        << tl::make_attr("messages_loaded_from_mdb_count", messagesStats.loadedFromMdbCount)
        << tl::make_attr("storage_requests_count", messagesStats.storageRequestsCount)
        << tl::make_attr("mbody_cache_hit_count", messagesStats.mbodyCacheHitCount)
        << tl::make_attr("total_time", toString(totalTime)) << makeUserAttrs(context)
        << makeExtraAttrs(extra);
}

tl::attributes_map makeUserAttrs(ImapContextPtr context)
{
    auto&& userData = context->userData;
    tl::attributes_map am;
    am << tl::make_attr("uid", userData.uid) << tl::make_attr("email", userData.email)
       << tl::make_attr("client_name", userData.clientId.name)
       << tl::make_attr("client_version", userData.clientId.version)
       << tl::make_attr("client_os", userData.clientId.OS)
       << tl::make_attr("client_os_version", userData.clientId.OSVersion)
       << tl::make_attr("client_vendor", userData.clientId.vendor)
       << tl::make_attr("ip", context->sessionInfo.remoteAddress);
    return am;
}

tl::attributes_map makeExtraAttrs(const ExtraStatFields& extra)
{
    tl::attributes_map am;
    for (auto&& [key, value] : extra)
    {
        am << tl::make_attr(key, value);
    }
    return am;
}

}
