#pragma once

#include <common/user_data.h>
#include <common/imap_context.h>
#include <common/messages_stats.h>
#include <string>

namespace yimap::typed {

using ExtraStatFields = map<string, string>;

void logAuth(ImapContextPtr context, const std::string& status, const std::string& reason);

void logCommandComplete(
    ImapContextPtr context,
    const string& status,
    const string& commandName,
    const string& commandText,
    size_t commandLength,
    const Duration& totalTime,
    const MessagesStats& messagesStats,
    const ExtraStatFields& extra);
}