LIBRARY()
OWNER(g:xeno)

NO_UTIL()
NO_WERROR()

CFLAGS(
    -DBOOST_SPIRIT_THREADSAFE
    -DMSGPACK_DEFAULT_API_VERSION=1
)

PEERDIR(
    contrib/libs/msgpack
    contrib/restricted/boost/crc
    mail/imap_protocol
    mail/ymod_blackbox
    mail/ymod_tvm
    mail/ymod_httpclient
    mail/ymod_ratecontroller
    mail/ymod_statserver
    mail/ymod_metricserver
    mail/ymod_webserver
    mail/yplatform/lib
    mail/yplatform/lib/convert
    mail/macs
    mail/macs_pg
    mail/mimeparser
    mail/user_journal
    mail/webmail-recognizer/lib
)

ADDINCL(
    mail/imap/src
    mail/webmail-recognizer/lib
)

SRCS(
    backend/backend.cc
    backend/backend_types.cpp
    backend/envelope.cc
    backend/msearch.cc
    backend/append/append.cpp
    backend/append/smtp_protocol.cc
    backend/append/sock_wrap.cc
    backend/auth_ymodbb/auth_backend_ymodbb.cc
    backend/meta_pg/mapped_folder.cc
    backend/meta_pg/pg_backend.cc
    backend/meta_pg/pg_messages.cc
    backend/meta_pg/pg_worker.cpp
    backend/mbody/body_structure_loader.cpp
    backend/mbody/message_loader.cpp
    backend/mbody/storage/string_storage.cpp
    backend/misc/spam_report.cpp
    backend/xiva/dispatcher.cc
    backend/xiva/backend.cc

    common/global_stats.cc
    common/flags.cc
    common/mailbox_diff.cc
    common/message_data.cc
    common/message_set.cc
    common/folder_list.cc
    common/imap_context.cc
    common/uid_map.cc
    common/helpers/helpers.cpp
    common/helpers/host_id.cpp
    common/helpers/utf7imap.cpp
    common/log/log.cpp
    common/log/logger.cpp
    common/log/session_logger.cc
    common/settings.cc
    common/lang_config.cc

    network/session.cc
    network/client_stream.cc

    parser/date_grammar.cc
    parser/rfc822/rfc822.cpp

    commands/factory.cc
    commands/imap_command.cc
    commands/append.cc
    commands/capability.cc
    commands/create.cc
    commands/close.cc
    commands/expunge.cc
    commands/copy.cc
    commands/delete.cc
    commands/enable.cc
    commands/examine.cc
    commands/fetch.cc
    commands/id.cc
    commands/idle.cc
    commands/list.cc
    commands/list/wildcards.cc
    commands/login_authenticate.cc
    commands/logout.cc
    commands/move.cc
    commands/namespace.cc
    commands/noop.cc
    commands/rename.cc
    commands/search.cc
    commands/search/factory.cc
    commands/starttls.cc
    commands/status.cc
    commands/store.cc
    commands/subscribe_unsubscribe.cc
    commands/unselect.cc
    commands/fetch/attribute.cc
    commands/fetch/attribute_fetcher.cc

    typed_log/typed_log.cc

    GLOBAL backend/impl.cc
    GLOBAL backend/mbody/storage/message_storage.cpp
    GLOBAL backend/xiva/module.cc
    GLOBAL parser/module.cc
    GLOBAL module.cc
    protocol_coroutine.cc
    read_exec_commands_loop.cc
)

END()
