package ru.yandex.personal.mailimport.controllers;

import java.util.List;

import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;

import ru.yandex.personal.mailimport.model.MailAccount;
import ru.yandex.personal.mailimport.model.Mailbox;
import ru.yandex.personal.mailimport.service.BackgroundMailImportTaskMessage;

@Path("v1/mail")
@Produces(MediaType.APPLICATION_JSON)
@Consumes(MediaType.APPLICATION_JSON)
public interface MailMappings {
    @Path("sync")
    @POST
    void synchronizeMailBox(Mailbox mailbox);

    @Path("async")
    @POST
    BackgroundMailImportTaskMessage synchronizeMailBoxAsynchronously(Mailbox mailbox);

    @Path("async/{id}")
    @GET
    BackgroundMailImportTaskMessage getMessage(@PathParam("id") String id);

    @Path("async/{id}/wait")
    @GET
    BackgroundMailImportTaskMessage waitForImport(@PathParam("id") String id);

    @Path("list")
    @POST
    List<String> listFolders(MailAccount mailAccount);
}
