package ru.yandex.personal.mailimport.model;

import com.google.common.base.Objects;

public class MailAccount {
    private final String host;
    private final String login;
    private final String password;

    public MailAccount() {
        this.host = null;
        this.login = null;
        this.password = null;
    }

    public MailAccount(String host, String login, String password) {
        this.host = host;
        this.login = login;
        this.password = password;
    }

    public String getHost() {
        return host;
    }

    public String getLogin() {
        return login;
    }

    public String getPassword() {
        return password;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MailAccount)) {
            return false;
        }
        MailAccount that = (MailAccount) o;
        return Objects.equal(host, that.host) &&
                Objects.equal(login, that.login) &&
                Objects.equal(password, that.password);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(host, login, password);
    }
}
