package ru.yandex.personal.mailimport.model;

import java.time.Instant;
import java.util.List;

public class MailMessage {
    private final String subject;
    private final MailPerson sender;
    private final List<MailPerson> toReceivers;
    private final List<MailPerson> ccReceivers;
    private final List<MailPerson> bccReceivers;
    private final Instant timestamp;
    private final MailMultipartMessageBody body;
    private final String textBody;

    public MailMessage() {
        this.subject = null;
        this.sender = null;
        this.toReceivers = null;
        this.ccReceivers = null;
        this.bccReceivers = null;
        this.timestamp = null;
        this.body = null;
        this.textBody = null;
    }

    public MailMessage(String subject, MailPerson sender, List<MailPerson> toReceivers,
            List<MailPerson> ccReceivers, List<MailPerson> bccReceivers,
            Instant timestamp,
            MailMultipartMessageBody body, String textBody)
    {
        this.subject = subject;
        this.sender = sender;
        this.toReceivers = toReceivers;
        this.ccReceivers = ccReceivers;
        this.bccReceivers = bccReceivers;
        this.timestamp = timestamp;
        this.body = body;
        this.textBody = textBody;
    }

    public String getSubject() {
        return subject;
    }

    public MailPerson getSender() {
        return sender;
    }

    public List<MailPerson> getToReceivers() {
        return toReceivers;
    }

    public List<MailPerson> getCcReceivers() {
        return ccReceivers;
    }

    public List<MailPerson> getBccReceivers() {
        return bccReceivers;
    }

    public Instant getTimestamp() {
        return timestamp;
    }

    public MailMultipartMessageBody getBody() {
        return body;
    }

    public String getTextBody() {
        return textBody;
    }
}
