package ru.yandex.personal.mailimport.model;

import java.util.List;

public class Mailbox {
    private final MailAccount mailAccount;
    private final List<MailFolder> folders;

    public Mailbox() {
        mailAccount = null;
        folders = null;
    }

    public Mailbox(MailAccount mailAccount, List<MailFolder> folders) {
        this.mailAccount = mailAccount;
        this.folders = folders;
    }

    public MailAccount getMailAccount() {
        return mailAccount;
    }

    public List<MailFolder> getFolders() {
        return folders;
    }

    public int size() {
        return folders.stream().mapToInt(f -> f.getMessages().size()).sum();
    }
}
