package ru.yandex.personal.mailimport.service;

import java.util.concurrent.atomic.AtomicReference;

import ru.yandex.personal.mailimport.model.MailFolder;
import ru.yandex.personal.mailimport.model.Mailbox;

public class BackgroundMailImportTask implements Runnable {
    private final AtomicReference<BackgroundMailImportStatus> message = new AtomicReference<>();
    private final Mailbox mailbox;
    private final int mailboxSize;

    public BackgroundMailImportTask(Mailbox mailbox) {
        this.mailbox = mailbox;
        mailboxSize = mailbox.size();
        message.set(new BackgroundMailImportStatus("Initializing", 0, mailboxSize));
    }

    @Override
    public void run() {
        ImapConnection connection = new ImapConnection(mailbox.getMailAccount());
        ImapMailbox imapMailbox = new ImapMailbox(connection);

        message.set(new BackgroundMailImportStatus("Clearing mailbox", 0, mailboxSize));
        imapMailbox.clear();

        message.set(new BackgroundMailImportStatus("Importing messages", 0, mailboxSize));
        int imported = 0;
        for (MailFolder mf : mailbox.getFolders()) {
            imapMailbox.addFolder(mf);
            imported += mf.getMessages().size();
            message.set(new BackgroundMailImportStatus("Importing messages", imported, mailboxSize));
        }
        message.set(new BackgroundMailImportStatus("Mailbox imported", imported, mailboxSize, true));
    }

    public BackgroundMailImportStatus getMessage() {
        return message.get();
    }
}
