package ru.yandex.personal.mailimport.service;

import java.util.Properties;

import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Store;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.personal.mailimport.model.MailAccount;

public class ImapConnection {
    private static final Logger LOG = LoggerFactory.getLogger(ImapConnection.class);

    private static final String PROTOCOL_PROPERTY_KEY = "mail.store.protocol";
    private static final String PROTOCOL = "imaps";

    private final String host;
    private final String login;
    private final String password;

    private Session session;
    private Store store;

    public ImapConnection(MailAccount mailAccount) {
        this.host = mailAccount.getHost();
        this.login = mailAccount.getLogin();
        this.password = mailAccount.getPassword();
    }

    public Store getStore() {
        if (store == null) {
            createStore();
        }
        return store;
    }

    public Session getSession() {
        if (session == null) {
            startSession();
        }

        return session;
    }

    private void createStore() {
        try {
            Store store = getSession().getStore(PROTOCOL);

            LOG.debug("Connecting to IMAP server on " + host);
            store.connect(host, login, password);
            LOG.debug("Connection successful");

            this.store = store;
        } catch (MessagingException e) {
            throw new RuntimeException(e);
        }
    }

    private void startSession() {
        LOG.debug("Starting IMAP session");
        Properties props = System.getProperties();
        props.setProperty(PROTOCOL_PROPERTY_KEY, PROTOCOL);
        session = Session.getDefaultInstance(props, null);
    }
}
