#pragma once

/**
 * Boost.Asio-like "handler - async_result" concept implementation.
 * We don't use Boost.Asio directly since it needs to specialize templates in it's
 * namespace. This way we can affect our users. What's why we use some abridged
 * version in our own namespace.
 */

#include <io_result/handler_type.h>

namespace io_result {


/// An interface for customising the behaviour of an initiating function.
/**
 * This template may be specialised for user-defined handler types.
 */
template <typename Handler>
class async_result {
public:
  /**
   * When using a specalised async_result, the constructor has an opportunity
   * to initialise some state associated with the handler, which is then
   * returned from the initiating function.
   */
  explicit async_result(Handler&) {}

  /// Obtain the value to be returned from the initiating function.
  void get() {}
};

namespace detail {

template<typename Handler, typename Signature>
struct init_async_result {
    init_async_result(const init_async_result& ) = delete;
    init_async_result& operator = (const init_async_result&) = delete;

    explicit init_async_result(Handler& orig_handler)
    : handler(orig_handler), result(handler) {}

    using handler_type = typename handler_type<Handler, Signature>::type;
    using result_type = async_result<handler_type>;

    handler_type handler;
    result_type result;
};

} // namespace detail

} // namespace io_result
