#pragma once

#include <tuple>
#include <utility>

#include <boost/asio/associated_executor.hpp>

namespace io_result {

template <typename Handler, typename ... Args>
struct binder {
    Handler handler;
    std::tuple<Args ...> args;

    auto operator() () & {
        return std::apply(handler, args);
    }

    auto operator() () && {
        return std::apply(std::move(handler), std::move(args));
    }

    auto operator() () const & {
        return std::apply(handler, args);
    }

    auto operator() () const && {
        return std::apply(std::move(handler), std::move(args));
    }

    using executor_type = decltype(boost::asio::get_associated_executor(handler));

    executor_type get_executor() const noexcept {
        return boost::asio::get_associated_executor(handler);
    }

    using allocator_type = decltype(boost::asio::get_associated_allocator(handler));

    allocator_type get_allocator() const noexcept {
        return boost::asio::get_associated_allocator(handler);
    }
};

template <typename Handler, typename ... Args>
inline auto bind(Handler&& handler, Args&& ... args) {
    using result_type = binder<std::decay_t<Handler>, std::decay_t<Args> ...>;
    return result_type {
        std::forward<Handler>(handler),
        std::make_tuple(std::forward<Args>(args)...)
    };
}

}
