#pragma once

/**
 * Boost.Asio-like "handler - async_result" concept implementation.
 * We don't use Boost.Asio directly since it needs to specialize templates in it's
 * namespace. This way we can affect our users. What's why we use some abridged
 * version in our own namespace.
 */

namespace io_result {

/// Default handler type traits provided for all handlers.
/**
 * This is handler selector prototype.
 * The handler_type traits class is used for determining the concrete handler
 * type to be used for an asynchronous operation. It allows the handler type to
 * be determined at the point where the specific completion handler signature
 * is known.
 *
 * This template may be specialised for user-defined handler types.
 */
template<typename Handler, typename Signature>
struct handler_type {
    using type = Handler;
};

} // namespace io_result
