from sendr_aiohttp.handler import request_schema, response_schema

from mail.ipa.ipa.api.handlers.base import BaseHandler
from mail.ipa.ipa.api.schemas.base import success_response_schema
from mail.ipa.ipa.api.schemas.path import org_id_collector_id_schema, org_id_schema
from mail.ipa.ipa.api.schemas.support import (
    support_collector_response_schema, support_collector_statuses_response_schema,
    support_collector_update_request_schema, support_collectors_request_schema, support_collectors_response_schema,
    support_events_request_schema, support_events_response_schema, support_users_request_schema,
    support_users_response_schema
)
from mail.ipa.ipa.core.actions.collectors.get import GetCollectorAction
from mail.ipa.ipa.core.actions.collectors.get_list import GetCollectorsListAction
from mail.ipa.ipa.core.actions.collectors.get_statuses import GetCollectorsStatusesAction
from mail.ipa.ipa.core.actions.collectors.remove import RemoveCollectorAction
from mail.ipa.ipa.core.actions.collectors.set_enabled import SetCollectorEnabledAction
from mail.ipa.ipa.core.actions.events.get_list import GetEventsListAction
from mail.ipa.ipa.core.actions.users.get_list import GetUsersListAction


class CollectorsListHandler(BaseHandler):
    @request_schema(org_id_schema, location='match_info')
    @request_schema(support_collectors_request_schema, location='query')
    @response_schema(support_collectors_response_schema)
    async def get(self):
        data = await self.get_data()
        collectors = await self.run_action(GetCollectorsListAction, **data)
        return self.make_schema_response({'data': collectors}, support_collectors_response_schema)


class CollectorHandler(BaseHandler):
    @request_schema(org_id_collector_id_schema, location='match_info')
    @response_schema(support_collectors_response_schema)
    async def get(self):
        data = await self.get_data()
        collector = await self.run_action(GetCollectorAction, **data)
        return self.make_schema_response({'data': collector}, support_collector_response_schema)

    @request_schema(org_id_collector_id_schema, location='match_info')
    @request_schema(support_collector_update_request_schema, location='json')
    @response_schema(success_response_schema)
    async def put(self):
        data = await self.get_data()
        await self.run_action(SetCollectorEnabledAction, **data)
        return self.make_schema_response({}, success_response_schema)

    @request_schema(org_id_collector_id_schema, location='match_info')
    @response_schema(success_response_schema)
    async def delete(self):
        data = await self.get_data()
        await self.run_action(RemoveCollectorAction, **data)
        return self.make_schema_response({}, success_response_schema)


class CollectorsStatusesHandler(BaseHandler):
    @request_schema(org_id_schema, location='match_info')
    @response_schema(support_collector_statuses_response_schema)
    async def get(self):
        data = await self.get_data()
        statuses = await self.run_action(GetCollectorsStatusesAction, **data)
        return self.make_schema_response({'data': statuses}, support_collector_statuses_response_schema)


class EventsListHandler(BaseHandler):
    @request_schema(org_id_schema, location='match_info')
    @request_schema(support_events_request_schema, location='query')
    @response_schema(support_events_response_schema)
    async def get(self):
        data = await self.get_data()
        data = await self.run_action(GetEventsListAction, **data)
        return self.make_schema_response({'data': data}, support_events_response_schema)


class UsersListHandler(BaseHandler):
    @request_schema(org_id_schema, location='match_info')
    @request_schema(support_users_request_schema, location='query')
    @response_schema(support_users_response_schema)
    async def get(self):
        data = await self.get_data()
        data = await self.run_action(GetUsersListAction, **data)
        return self.make_schema_response({'data': data}, support_users_response_schema)
