from sendr_aiohttp.handler import request_schema, response_schema

from mail.ipa.ipa.api.handlers.base import BaseHandler
from mail.ipa.ipa.api.schemas.path import org_id_schema
from mail.ipa.ipa.api.schemas.tasks import tasks_request_schema, tasks_response_schema
from mail.ipa.ipa.core.actions.tasks import GetTasksAction


class TasksHandler(BaseHandler):
    @request_schema(org_id_schema, location='match_info')
    @request_schema(tasks_request_schema, location='query')
    @response_schema(tasks_response_schema)
    async def get(self):
        data = await self.get_data()
        tasks_page = await self.run_action(GetTasksAction,
                                           org_id=data['org_id'],
                                           limit=data['limit'],
                                           offset=data['offset'])
        return self.make_response({
            'data': tasks_page,
        })
