from sendr_aiohttp import Url

from mail.ipa.ipa.api.handlers.import_ import ImportHandler, ReportImportHandler, StatImportHandler, StopImportHandler
from mail.ipa.ipa.api.handlers.support import (
    CollectorHandler, CollectorsListHandler, CollectorsStatusesHandler, EventsListHandler, UsersListHandler
)
from mail.ipa.ipa.api.handlers.tasks import TasksHandler

APP_ROUTES = (
    Url(r'/import/{org_id}/', ImportHandler, name='create_import'),
    Url(r'/import/{org_id}/report/', ReportImportHandler, name='report_import'),
    Url(r'/import/{org_id}/stat/', StatImportHandler, name='stat_import'),
    Url(r'/import/{org_id}/tasks/', TasksHandler, name='tasks'),
    Url(r'/import/{org_id}/stop/', StopImportHandler, name='stop_import'),

    Url(r'/support/{org_id}/collectors/', CollectorsListHandler, name='support_collectors'),
    Url(r'/support/{org_id}/collectors-statuses/', CollectorsStatusesHandler, name='support_collectors_statuses'),
    Url(r'/support/{org_id}/collectors/{collector_id}/', CollectorHandler, name='support_collector'),
    Url(r'/support/{org_id}/events/', EventsListHandler, name='support_events'),
    Url(r'/support/{org_id}/users/', UsersListHandler, name='support_users'),
)
