import ujson
from marshmallow import Schema, fields, validate


class BaseSchema(Schema):
    class Meta:
        json_module = ujson
        strict = True


class BasePaginatedRequestSchema(BaseSchema):
    limit = fields.Integer(missing=20, validate=validate.Range(min=1, max=100))
    offset = fields.Integer(missing=0, validate=validate.Range(min=0))


class BaseResponseSchema(BaseSchema):
    code: fields.Field = fields.Integer()
    status: fields.Field = fields.String()
    data: fields.Field = fields.Dict(default=None)


class BaseStatsSchema(BaseSchema):
    total = fields.Integer()
    collected = fields.Integer()
    errors = fields.Integer()


class SuccessResponseSchema(BaseResponseSchema):
    code = fields.Constant(200)
    status = fields.Constant('success')


class FailDataSchema(BaseSchema):
    message = fields.String()
    params = fields.Dict()


class FailResponseSchema(BaseResponseSchema):
    code = fields.Integer()
    status = fields.Constant('fail')
    data = fields.Nested(FailDataSchema)


success_response_schema = SuccessResponseSchema()
fail_response_schema = FailResponseSchema()
