from marshmallow import fields, validate
from marshmallow_enum import EnumField

from mail.ipa.ipa.api.schemas.base import BaseSchema, BaseStatsSchema
from mail.ipa.ipa.core.entities.enums import UserImportError


class ImportParamsSchema(BaseSchema):
    server = fields.String(required=True, validate=validate.Length(min=1))
    port = fields.Integer(required=True, validate=validate.Range(min=0, max=65535))
    imap = fields.Boolean(required=True)
    ssl = fields.Boolean(required=True)
    mark_archive_read = fields.Boolean(required=True)
    delete_msgs = fields.Boolean(required=True)


class CollectorParamsSchema(ImportParamsSchema):
    src_login = fields.String()


class CollectorSchema(BaseStatsSchema):
    uid = fields.Integer()
    login = fields.String()
    params = fields.Nested(CollectorParamsSchema)
    error = EnumField(UserImportError, by_value=True)
