from marshmallow import fields

from mail.ipa.ipa.api.schemas.base import BaseSchema, SuccessResponseSchema
from mail.ipa.ipa.api.schemas.common import CollectorSchema, ImportParamsSchema


class UserImportSchema(BaseSchema):
    login = fields.String(required=True)
    password = fields.String(required=True)
    src_login = fields.String(required=True)


class CreateImportRequestSchema(ImportParamsSchema):
    admin_uid = fields.Integer(required=True)
    user_ip = fields.String(required=True)


class CreateImportFromCSVRequestSchema(CreateImportRequestSchema):
    name = fields.String(missing='')


class CreateImportJSONBodySchema(BaseSchema):
    users = fields.Nested(UserImportSchema, many=True, missing=list)


class CreateImportOrgIdRequestSchema(BaseSchema):
    org_id = fields.Integer(required=True)


class CreateTaskSchema(BaseSchema):
    task_id = fields.String()


class CreateTaskResponseSchema(SuccessResponseSchema):
    data = fields.Nested(CreateTaskSchema)


class ImportStatSchema(BaseSchema):
    total = fields.Integer()
    errors = fields.Integer()
    finished = fields.Integer()


class StatImportResponseSchema(SuccessResponseSchema):
    data = fields.Nested(ImportStatSchema)


class ImportInfoSchema(BaseSchema):
    collectors = fields.Nested(CollectorSchema, many=True)
    has_more = fields.Boolean()


class InfoImportParamsSchema(BaseSchema):
    only_errors = fields.Boolean(missing=False)


class InfoImportResponseSchema(SuccessResponseSchema):
    data = fields.Nested(ImportInfoSchema)


create_import_from_csv_request_schema = CreateImportFromCSVRequestSchema()
create_import_json_body_schema = CreateImportJSONBodySchema()
create_import_org_id_request_schema = CreateImportOrgIdRequestSchema()
create_import_request_schema = CreateImportRequestSchema()
create_task_response_schema = CreateTaskResponseSchema()

info_import_params_schema = InfoImportParamsSchema()
info_import_response_schema = InfoImportResponseSchema()

stat_import_response_schema = StatImportResponseSchema()
