from marshmallow import fields
from marshmallow.validate import Range

from mail.ipa.ipa.api.schemas.base import BaseSchema, SuccessResponseSchema
from mail.ipa.ipa.conf import settings
from mail.ipa.ipa.core.entities.enums import TaskType


class TasksRequestSchema(BaseSchema):
    offset = fields.Integer(missing=0, validate=Range(min=0))
    limit = fields.Integer(missing=settings.TASKS_API_DEFAULT_LIMIT,
                           validate=Range(min=1, max=settings.TASKS_API_MAX_LIMIT))


def dump_task_type(obj):
    if obj.task_type == TaskType.PARSE_CSV:
        return 'csv'
    if obj.task_type == TaskType.INIT_IMPORT:
        return 'json'
    if obj.task_type == TaskType.STOP_IMPORT:
        return 'stop'
    return 'unknown'


class TaskSchema(BaseSchema):
    task_id = fields.String()
    task_type = fields.Function(serialize=dump_task_type, dump_to='type')
    created = fields.DateTime(dump_to='created_at')
    finished = fields.Boolean()
    has_errors = fields.Boolean()
    meta_info = fields.Dict(dump_to='params')


class TasksSchema(BaseSchema):
    tasks = fields.Nested(TaskSchema, many=True)
    total = fields.Integer()


class TasksResponseSchema(SuccessResponseSchema):
    data = fields.Nested(TasksSchema)


tasks_response_schema = TasksResponseSchema()
tasks_request_schema = TasksRequestSchema()
