import asyncio

import click
import uvloop


async def generate_ammo(tasks_org_id: int, stat_org_id: int) -> None:
    req_template = (
        "%s %s HTTP/1.1\r\n"
        "%s\r\n"
        "\r\n"
    )
    ammo_template = (
        "%d %s\n"
        "%s"
    )

    for i in [f'/import/{tasks_org_id}/tasks/', f'/import/{stat_org_id}/stat/']:
        headers = "host: load.ipa.mail.yandex.net\r\n" + \
                  "user-agent: tank\r\n" + \
                  "accept: */*\r\n" + \
                  "Connection: Close"
        req = req_template % ('GET', i, headers)
        print(ammo_template % (len(req), 'simple', req))


@click.command()  # pragma: nocover
@click.option('--tasks-org-id', help='/import/{tasks_org_id}/tasks/', default=123)  # pragma: nocover
@click.option('--stat-org-id', help='/import/{stat_org_id}/stat/', default=456)  # pragma: nocover
def cli(tasks_org_id: int, stat_org_id: int) -> None:  # pragma: nocover
    """
    Generates ammo for load tests.
    Usage: manage.py generate_load_ammo --service-ticket=TICKETHERE
    """
    asyncio.set_event_loop_policy(uvloop.EventLoopPolicy())
    loop = asyncio.get_event_loop()

    loop.run_until_complete(generate_ammo(tasks_org_id, stat_org_id))
