import asyncio

import click
import uvloop
from aiohttp import web

from mail.ipa.ipa.api.app import IpaApplication
from mail.ipa.ipa.utils.logging import configure_logging


@click.command()
@click.option('--port', default=8002, help='Port number')
@click.option('--host', default='127.0.0.1', help='Bind address')
def cli(port, host):
    """Starts api web server.
    Usage: manage.py runserver --port=8002 --host=127.0.0.1
    """

    asyncio.set_event_loop_policy(uvloop.EventLoopPolicy())
    configure_logging()

    app = IpaApplication()

    web.run_app(app, port=port, host=host)
