from mail.ipa.ipa.core.actions.base import BaseRunAsyncDBAction
from mail.ipa.ipa.core.actions.collectors.set_enabled import SetCollectorEnabledAction
from mail.ipa.ipa.core.entities.enums import TaskType
from mail.ipa.ipa.core.entities.password import Password


class EditCollectorAction(BaseRunAsyncDBAction):
    transact = True
    task_type = TaskType.EDIT_COLLECTOR

    def __init__(self, collector_id: int, password: Password):
        super().__init__()
        self.collector_id: int = collector_id
        self.password: Password = password

    async def handle(self) -> None:
        collector = await self.storage.collector.get(self.collector_id)
        user = await self.storage.user.get(collector.user_id)

        dir_user = await self.clients.directory.get_user_by_login(user.org_id, user.login)

        assert user.suid is not None, 'User should be initialized'
        assert collector.pop_id is not None, 'Collector should be initialized'

        await self.clients.yarm.edit(user.suid, collector.pop_id, dir_user.email, self.password.value())
        await SetCollectorEnabledAction(collector_id=self.collector_id, enabled=True).run_async(user.user_id)

        collector.status = collector.OK_STATUS
        await self.storage.collector.save(collector)
