from datetime import datetime
from typing import List, Optional

from sendr_utils import alist

from mail.ipa.ipa.core.actions.base import BaseDBAction
from mail.ipa.ipa.core.entities.collector import Collector


class GetCollectorsListAction(BaseDBAction):
    def __init__(self, org_id: int,
                 limit: Optional[int] = None,
                 offset: Optional[int] = None,
                 status: Optional[str] = None,
                 login: Optional[str] = None,
                 created_from: Optional[datetime] = None,
                 created_to: Optional[datetime] = None):
        super().__init__()
        self.org_id = org_id
        self.limit = limit
        self.status = status
        self.login = login
        self.offset = offset
        self.created_at_from = created_from
        self.created_at_to = created_to

    async def handle(self) -> List[Collector]:
        return await alist(
            self.storage.collector.find(
                org_id=self.org_id,
                created_at_from=self.created_at_from,
                created_at_to=self.created_at_to,
                status=self.status,
                login=self.login,
                limit=self.limit,
                offset=self.offset,
                order_by=('-user_id', '-collector_id')
            )
        )
