from typing import List

from sendr_utils import alist

from mail.ipa.ipa.core.actions.base import BaseDBAction


class GetCollectorsStatusesAction(BaseDBAction):
    def __init__(self, org_id: int):
        super().__init__()
        self.org_id = org_id

    async def handle(self) -> List[str]:
        return await alist(self.storage.collector.find_statuses(org_id=self.org_id))
