from sendr_utils import alist

from mail.ipa.ipa.core.actions.base import BaseDBAction
from mail.ipa.ipa.core.entities.collector import Collector
from mail.ipa.ipa.core.entities.import_params import ImportParams
from mail.ipa.ipa.core.entities.user import User
from mail.ipa.ipa.interactions.yarm.entities import YarmCollectorState


class InheritUserCollectorsAction(BaseDBAction):
    def __init__(self, user: User):
        super().__init__()
        self.user: User = user

    async def handle(self) -> None:
        with self.logger:
            user = self.user
            db_collectors = await alist(self.storage.collector.find(user_id=user.user_id))

            assert user.user_id is not None, 'User should be persistent'
            assert user.uid is not None and user.suid is not None, 'User uid/suid should be initialized'

            async for collector in self.clients.yarm.list(suid=user.suid):
                pop_id = collector.pop_id
                for db_collector in db_collectors:
                    if db_collector.pop_id == pop_id:
                        break
                else:
                    new_collector = Collector(
                        user_id=user.user_id,
                        params=ImportParams(
                            src_login=collector.email,
                            server=collector.server,
                            port=collector.port,
                            ssl=collector.ssl,
                            delete_msgs=collector.delete_msgs,
                            imap=collector.imap,
                            mark_archive_read=False,  # почему-то это поле не отдаётся из yarm api
                        ),
                        enabled=collector.state != YarmCollectorState.OFF,
                        pop_id=pop_id,
                    )
                    new_collector = await self.storage.collector.create(new_collector)
                    self.logger.context_push(pop_id=pop_id, collector_id=new_collector.collector_id)
                    self.logger.info('Inherited collector')
