from datetime import datetime
from typing import List, Optional

from sendr_utils import alist

from mail.ipa.ipa.core.actions.base import BaseDBAction
from mail.ipa.ipa.core.entities.enums import EventType
from mail.ipa.ipa.core.entities.event import Event


class GetEventsListAction(BaseDBAction):
    def __init__(self, org_id: int,
                 limit: Optional[int] = None,
                 offset: Optional[int] = None,
                 event_type: Optional[EventType] = None,
                 created_from: Optional[datetime] = None,
                 created_to: Optional[datetime] = None):
        super().__init__()
        self.org_id = org_id
        self.event_type = event_type
        self.limit = limit
        self.offset = offset
        self.created_at_from = created_from
        self.created_at_to = created_to

    async def handle(self) -> List[Event]:
        return await alist(
            self.storage.event.find(
                org_id=self.org_id,
                event_type=self.event_type,
                offset=self.offset,
                created_at_from=self.created_at_from,
                created_at_to=self.created_at_to,
                limit=self.limit,
                order_by=('-event_id',),
                iterator=True,
            )
        )
