from dataclasses import asdict
from typing import Any, Dict, List

from mail.ipa.ipa.core.actions.import_.base import BaseCreateImportTaskAction
from mail.ipa.ipa.core.actions.import_.org import InitOrgImportAction
from mail.ipa.ipa.core.entities.import_params import GeneralInitImportParams
from mail.ipa.ipa.core.entities.task import Task
from mail.ipa.ipa.core.entities.user_info import UserInfo
from mail.ipa.ipa.core.exceptions import ImportEmptyError


class CreateImportFromJSONAction(BaseCreateImportTaskAction):
    GENERATE_START_EVENT = True

    def __init__(self, params: GeneralInitImportParams, users: List[UserInfo]):
        super().__init__(params.org_id)
        self.params = params
        self.users = users

    def _get_event_logging_data(self) -> Dict[str, Any]:
        return {'count': len(self.users), 'params': asdict(self.params)}

    async def _handle(self) -> Task:
        if not self.users:
            raise ImportEmptyError

        return await InitOrgImportAction(
            params=self.params,
            users=self.users,
        ).run_async(self.org_id, meta_info={'count': len(self.users)})
