from mail.ipa.ipa.core.actions.base import BaseRunAsyncDBAction
from mail.ipa.ipa.core.actions.import_.base import BaseCreateImportTaskAction
from mail.ipa.ipa.core.actions.users.remove_collectors import RemoveUserCollectorsAction
from mail.ipa.ipa.core.entities.enums import EventType, TaskType
from mail.ipa.ipa.core.entities.event import Event
from mail.ipa.ipa.core.entities.org import Org
from mail.ipa.ipa.core.entities.task import Task


class StopOrgImportAction(BaseRunAsyncDBAction):
    task_type = TaskType.STOP_IMPORT
    transact = True

    def __init__(self, org_id: int) -> None:
        super().__init__()
        self.org_id: int = org_id

    async def handle(self) -> None:
        org_id = self.org_id

        async for user in self.storage.user.find(org_id=org_id):
            assert user.user_id is not None
            if user.error is not None:
                await self.storage.user.delete(user)
            else:
                await RemoveUserCollectorsAction(user_id=user.user_id).run_async(entity_id=user.user_id)


class CreateStopImportAction(BaseCreateImportTaskAction):
    def __init__(self, org_id: int):
        super().__init__(org_id)

    async def _generate_event(self, org: Org) -> None:
        assert org.org_id is not None

        await self.storage.event.create(
            Event(
                event_type=EventType.STOP,
                org_id=org.org_id,
                revision=org.revision,
                data=self._get_event_logging_data(),
            )
        )

    async def _handle(self) -> Task:
        return await StopOrgImportAction(org_id=self.org_id).run_async(entity_id=self.org_id, meta_info={})
