from typing import Any, Dict

from mail.ipa.ipa.core.actions.base import BaseRunAsyncAction
from mail.ipa.ipa.core.actions.collectors.init import InitCollectorAction
from mail.ipa.ipa.core.actions.users.init import InitUserAction
from mail.ipa.ipa.core.entities.enums import TaskType
from mail.ipa.ipa.core.entities.import_params import GeneralInitImportParams
from mail.ipa.ipa.core.entities.password import Password
from mail.ipa.ipa.core.entities.user_info import UserInfo


class InitUserImportAction(BaseRunAsyncAction):
    task_type = TaskType.INIT_USER_IMPORT

    @classmethod
    def deserialize_kwargs(cls, params: Dict[str, Any]) -> Dict[str, Any]:
        user_info = UserInfo(**params['user_info'])
        user_info.password = Password(**params['user_info']['password'])
        if params['user_info'].get('new_password'):
            user_info.new_password = Password(**params['user_info']['new_password'])
        return {
            'import_params': GeneralInitImportParams(**params['import_params']),
            'user_id': params['user_id'],
            'user_info': user_info,
        }

    def __init__(self, import_params: GeneralInitImportParams, user_id: int, user_info: UserInfo):
        super().__init__()
        self.import_params: GeneralInitImportParams = import_params
        self.user_id: int = user_id
        self.info: UserInfo = user_info

    async def handle(self) -> None:
        with self.logger:
            self.logger.context_push(user_id=self.user_id)

            user, directory_user = await InitUserAction(user_id=self.user_id,
                                                        admin_uid=self.import_params.admin_uid,
                                                        user_info=self.info,
                                                        user_ip=self.import_params.user_ip,
                                                        ).run()

            await InitCollectorAction(user=user,
                                      directory_user=directory_user,
                                      import_params=self.import_params,
                                      src_login=self.info.src_login,
                                      src_password=self.info.password,
                                      ).run()
