from mail.ipa.ipa.core.actions.base import BaseDBAction
from mail.ipa.ipa.core.entities.stat import ImportStat


class GetImportStatAction(BaseDBAction):
    def __init__(self, org_id: int):
        super().__init__()
        self.org_id: int = org_id

    async def handle(self):
        user_stat = await self.storage.stat.get_user_stat(org_id=self.org_id)
        collector_stat = await self.storage.stat.get_collector_stat(org_id=self.org_id)
        return ImportStat(
            total=user_stat.errors + collector_stat.total,
            finished=collector_stat.finished,
            errors=user_stat.errors + collector_stat.errors,
        )
