from sendr_utils import alist

from mail.ipa.ipa.core.actions.base import BaseDBAction
from mail.ipa.ipa.core.entities.enums import TaskType
from mail.ipa.ipa.core.entities.task import TasksPage


class GetTasksAction(BaseDBAction):
    def __init__(self, org_id: int, offset: int, limit: int) -> None:
        super().__init__()
        self.org_id: int = org_id
        self.limit: int = limit
        self.offset: int = offset

    async def handle(self) -> TasksPage:
        task_types = (
            TaskType.PARSE_CSV,
            TaskType.INIT_IMPORT,
            TaskType.STOP_IMPORT,
        )
        tasks = await alist(self.storage.task.get_org_tasks(org_id=self.org_id,
                                                            task_types=task_types,
                                                            offset=self.offset,
                                                            limit=self.limit))
        total = await self.storage.task.get_org_tasks_count(org_id=self.org_id, task_types=task_types)

        return TasksPage(
            tasks=tasks,
            offset=self.offset,
            limit=self.limit,
            total=total,
        )
