from typing import List, Optional

from sendr_utils import alist

from mail.ipa.ipa.core.actions.base import BaseDBAction
from mail.ipa.ipa.core.entities.user import User


class GetUsersListAction(BaseDBAction):
    def __init__(self, org_id: int,
                 login: Optional[str] = None,
                 limit: Optional[int] = None,
                 offset: Optional[int] = None):
        super().__init__()
        self.org_id = org_id
        self.login = login
        self.limit = limit
        self.offset = offset

    async def handle(self) -> List[User]:
        return await alist(
            self.storage.user.find(
                self.org_id,
                login=self.login,
                limit=self.limit,
                offset=self.offset
            )
        )
