from mail.ipa.ipa.core.actions.base import BaseRunAsyncDBAction
from mail.ipa.ipa.core.actions.collectors.remove import RemoveCollectorAction
from mail.ipa.ipa.core.entities.enums import TaskType


class RemoveUserCollectorsAction(BaseRunAsyncDBAction):
    task_type = TaskType.REMOVE_USER_COLLECTORS
    transact = True

    def __init__(self, user_id: int):
        super().__init__()
        self.user_id: int = user_id

    async def handle(self):
        self.logger.context_push(user_id=self.user_id)
        user = await self.storage.user.get(self.user_id)
        self.logger.context_push(uid=user.uid, suid=user.suid)

        async for collector in self.storage.collector.find(user_id=user.user_id):
            await RemoveCollectorAction(collector=collector).run()
        self.logger.info('Removed user collectors')
