from mail.ipa.ipa.conf import settings
from mail.ipa.ipa.core.crypto.fernet import Fernet as BaseFernet
from mail.ipa.ipa.core.crypto.versioned import (
    VersionedKeyStorage, VersionedManagedBlockDecryptor, VersionedManagedBlockEncryptor
)

_key_version_storage: VersionedKeyStorage = VersionedKeyStorage(settings.KEY_VERSIONS)


class Fernet(BaseFernet):
    def __init__(self) -> None:
        super().__init__(_key_version_storage)


class BlockEncryptor(VersionedManagedBlockEncryptor):
    def __init__(self) -> None:
        super().__init__(_key_version_storage)


class BlockDecryptor(VersionedManagedBlockDecryptor):
    def __init__(self) -> None:
        super().__init__(_key_version_storage)
